package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ProviderSASLServerFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ProviderSASLServerFactoryConsumer<T extends ProviderSASLServerFactory<T>> {

	/**
	 * Configure a pre-constructed instance of ProviderSASLServerFactory
	 * resource
	 * 
	 * @parameter Instance of ProviderSASLServerFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default ProviderSASLServerFactoryConsumer<T> andThen(
			ProviderSASLServerFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}