package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * Resource containing the association of a SecurityDomain with a
 * SaslServerFactory.
 */
@Address("/subsystem=elytron/sasl-authentication-factory=*")
@ResourceType("sasl-authentication-factory")
public class SASLAuthenticationFactory<T extends SASLAuthenticationFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The SASL mechanisms available from this configuration after all filtering has been applied.")
	private List<String> availableMechanisms;
	@AttributeDocumentation("Mechanism specific configuration")
	private List<java.util.Map> mechanismConfigurations;
	@AttributeDocumentation("The SaslServerFactory to associate with this resource")
	private String saslServerFactory;
	@AttributeDocumentation("The SecurityDomain to associate with this resource")
	private String securityDomain;

	public SASLAuthenticationFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The SASL mechanisms available from this configuration after all filtering
	 * has been applied.
	 */
	@ModelNodeBinding(detypedName = "available-mechanisms")
	public List<String> availableMechanisms() {
		return this.availableMechanisms;
	}

	/**
	 * The SASL mechanisms available from this configuration after all filtering
	 * has been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(java.util.List<String> value) {
		Object oldValue = this.availableMechanisms;
		this.availableMechanisms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this configuration after all filtering
	 * has been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanism(String value) {
		if (this.availableMechanisms == null) {
			this.availableMechanisms = new java.util.ArrayList<>();
		}
		this.availableMechanisms.add(value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this configuration after all filtering
	 * has been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(String... args) {
		availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Mechanism specific configuration
	 */
	@ModelNodeBinding(detypedName = "mechanism-configurations")
	public List<Map> mechanismConfigurations() {
		return this.mechanismConfigurations;
	}

	/**
	 * Mechanism specific configuration
	 */
	@SuppressWarnings("unchecked")
	public T mechanismConfigurations(java.util.List<java.util.Map> value) {
		Object oldValue = this.mechanismConfigurations;
		this.mechanismConfigurations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mechanismConfigurations", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Mechanism specific configuration
	 */
	@SuppressWarnings("unchecked")
	public T mechanismConfiguration(java.util.Map value) {
		if (this.mechanismConfigurations == null) {
			this.mechanismConfigurations = new java.util.ArrayList<>();
		}
		this.mechanismConfigurations.add(value);
		return (T) this;
	}

	/**
	 * Mechanism specific configuration
	 */
	@SuppressWarnings("unchecked")
	public T mechanismConfigurations(java.util.Map... args) {
		mechanismConfigurations(Arrays.stream(args)
				.collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The SaslServerFactory to associate with this resource
	 */
	@ModelNodeBinding(detypedName = "sasl-server-factory")
	public String saslServerFactory() {
		return this.saslServerFactory;
	}

	/**
	 * The SaslServerFactory to associate with this resource
	 */
	@SuppressWarnings("unchecked")
	public T saslServerFactory(java.lang.String value) {
		Object oldValue = this.saslServerFactory;
		this.saslServerFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslServerFactory", oldValue, value);
		return (T) this;
	}

	/**
	 * The SecurityDomain to associate with this resource
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The SecurityDomain to associate with this resource
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}
}