package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.SimpleRegexRealmMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SimpleRegexRealmMapperConsumer<T extends SimpleRegexRealmMapper<T>> {

	/**
	 * Configure a pre-constructed instance of SimpleRegexRealmMapper resource
	 * 
	 * @parameter Instance of SimpleRegexRealmMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default SimpleRegexRealmMapperConsumer<T> andThen(
			SimpleRegexRealmMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}