package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.SimpleRoleDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SimpleRoleDecoderConsumer<T extends SimpleRoleDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of SimpleRoleDecoder resource
	 * 
	 * @parameter Instance of SimpleRoleDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default SimpleRoleDecoderConsumer<T> andThen(
			SimpleRoleDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}