package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.JDBCStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JDBCStoreConsumer<T extends JDBCStore<T>> {

	/**
	 * Configure a pre-constructed instance of JDBCStore resource
	 * 
	 * @parameter Instance of JDBCStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default JDBCStoreConsumer<T> andThen(JDBCStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}