package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.TransportThreadPool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TransportThreadPoolConsumer<T extends TransportThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of TransportThreadPool resource
	 * 
	 * @parameter Instance of TransportThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default TransportThreadPoolConsumer<T> andThen(
			TransportThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}