package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.LoggingProfile;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LoggingProfileConsumer<T extends LoggingProfile<T>> {

	/**
	 * Configure a pre-constructed instance of LoggingProfile resource
	 * 
	 * @parameter Instance of LoggingProfile to configure
	 * @return nothing
	 */
	void accept(T value);

	default LoggingProfileConsumer<T> andThen(LoggingProfileConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}