package org.wildfly.swarm.config.mail.mail_session;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Mail session server
 */
@Address("/subsystem=mail/mail-session=*/server=smtp")
@ResourceType("server")
@Implicit
public class SMTPServer<T extends SMTPServer<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Credential (from Credential Store) to authenticate on server")
	private Map credentialReference;
	@AttributeDocumentation("Outbound Socket binding to mail server")
	private String outboundSocketBindingRef;
	@AttributeDocumentation("Password to authenticate on server")
	private String password;
	@AttributeDocumentation("Does server require SSL?")
	private Boolean ssl;
	@AttributeDocumentation("Does server require TLS?")
	private Boolean tls;
	@AttributeDocumentation("Username to authenticate on server")
	private String username;

	public SMTPServer() {
		super();
		this.key = "smtp";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Credential (from Credential Store) to authenticate on server
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * Credential (from Credential Store) to authenticate on server
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate on server
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * Outbound Socket binding to mail server
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding-ref")
	public String outboundSocketBindingRef() {
		return this.outboundSocketBindingRef;
	}

	/**
	 * Outbound Socket binding to mail server
	 */
	@SuppressWarnings("unchecked")
	public T outboundSocketBindingRef(java.lang.String value) {
		Object oldValue = this.outboundSocketBindingRef;
		this.outboundSocketBindingRef = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("outboundSocketBindingRef", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Password to authenticate on server
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * Password to authenticate on server
	 */
	@SuppressWarnings("unchecked")
	public T password(java.lang.String value) {
		Object oldValue = this.password;
		this.password = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("password", oldValue, value);
		return (T) this;
	}

	/**
	 * Does server require SSL?
	 */
	@ModelNodeBinding(detypedName = "ssl")
	public Boolean ssl() {
		return this.ssl;
	}

	/**
	 * Does server require SSL?
	 */
	@SuppressWarnings("unchecked")
	public T ssl(java.lang.Boolean value) {
		Object oldValue = this.ssl;
		this.ssl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ssl", oldValue, value);
		return (T) this;
	}

	/**
	 * Does server require TLS?
	 */
	@ModelNodeBinding(detypedName = "tls")
	public Boolean tls() {
		return this.tls;
	}

	/**
	 * Does server require TLS?
	 */
	@SuppressWarnings("unchecked")
	public T tls(java.lang.Boolean value) {
		Object oldValue = this.tls;
		this.tls = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tls", oldValue, value);
		return (T) this;
	}

	/**
	 * Username to authenticate on server
	 */
	@ModelNodeBinding(detypedName = "username")
	public String username() {
		return this.username;
	}

	/**
	 * Username to authenticate on server
	 */
	@SuppressWarnings("unchecked")
	public T username(java.lang.String value) {
		Object oldValue = this.username;
		this.username = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("username", oldValue, value);
		return (T) this;
	}
}