package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.BySearchTimeCache;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface BySearchTimeCacheConsumer<T extends BySearchTimeCache<T>> {

	/**
	 * Configure a pre-constructed instance of BySearchTimeCache resource
	 * 
	 * @parameter Instance of BySearchTimeCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default BySearchTimeCacheConsumer<T> andThen(
			BySearchTimeCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}