package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.BySearchTimeCacheSupplier;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheConsumer;
import org.wildfly.swarm.config.management.security_realm.ByAccessTimeCacheSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration to use LDAP as the user repository.
 */
@Address("/core-service=management/security-realm=*/authentication=ldap")
@ResourceType("authentication")
@Implicit
public class LdapAuthentication<T extends LdapAuthentication<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private LdapAuthenticationResources subresources = new LdapAuthenticationResources();
	@AttributeDocumentation("The fully defined filter to be used to search for the user based on their entered user ID. The filter should contain a variable in the form {0} - this will be replaced with the username supplied by the user.")
	private String advancedFilter;
	@AttributeDocumentation("Should empty passwords be accepted from the user being authenticated.")
	private Boolean allowEmptyPasswords;
	@AttributeDocumentation("The base distinguished name to commence the search for the user.")
	private String baseDn;
	@AttributeDocumentation("The name of the connection to use to connect to LDAP.")
	private String connection;
	@AttributeDocumentation("Whether the search should be recursive.")
	private Boolean recursive;
	@AttributeDocumentation("The name of the attribute which is the user's distinguished name.")
	private String userDn;
	@AttributeDocumentation("The name of the attribute to search for the user. This filter will then perform a simple search where the username entered by the user matches the attribute specified here.")
	private String usernameAttribute;
	@AttributeDocumentation("The name of the attribute that should be loaded from the authenticated users LDAP entry to replace the username that they supplied, e.g. convert an e-mail address to an ID or correct the case entered.")
	private String usernameLoad;

	public LdapAuthentication() {
		super();
		this.key = "ldap";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public LdapAuthenticationResources subresources() {
		return this.subresources;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(
			org.wildfly.swarm.config.management.security_realm.BySearchTimeCache value) {
		this.subresources.bySearchTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheConsumer consumer) {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache() {
		BySearchTimeCache<? extends BySearchTimeCache> child = new BySearchTimeCache<>();
		this.subresources.bySearchTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T bySearchTimeCache(BySearchTimeCacheSupplier supplier) {
		this.subresources.bySearchTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(
			org.wildfly.swarm.config.management.security_realm.ByAccessTimeCache value) {
		this.subresources.byAccessTimeCache = value;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheConsumer consumer) {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache() {
		ByAccessTimeCache<? extends ByAccessTimeCache> child = new ByAccessTimeCache<>();
		this.subresources.byAccessTimeCache = child;
		return (T) this;
	}

	/**
	 * A cache to hold the results of previous LDAP interactions.
	 */
	@SuppressWarnings("unchecked")
	public T byAccessTimeCache(ByAccessTimeCacheSupplier supplier) {
		this.subresources.byAccessTimeCache = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for LdapAuthentication
	 */
	public static class LdapAuthenticationResources {
		@SingletonResource
		@ResourceDocumentation("A cache to hold the results of previous LDAP interactions.")
		private BySearchTimeCache bySearchTimeCache;
		@SingletonResource
		@ResourceDocumentation("A cache to hold the results of previous LDAP interactions.")
		private ByAccessTimeCache byAccessTimeCache;

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public BySearchTimeCache bySearchTimeCache() {
			return this.bySearchTimeCache;
		}

		/**
		 * A cache to hold the results of previous LDAP interactions.
		 */
		@Subresource
		public ByAccessTimeCache byAccessTimeCache() {
			return this.byAccessTimeCache;
		}
	}

	/**
	 * The fully defined filter to be used to search for the user based on their
	 * entered user ID. The filter should contain a variable in the form {0} -
	 * this will be replaced with the username supplied by the user.
	 */
	@ModelNodeBinding(detypedName = "advanced-filter")
	public String advancedFilter() {
		return this.advancedFilter;
	}

	/**
	 * The fully defined filter to be used to search for the user based on their
	 * entered user ID. The filter should contain a variable in the form {0} -
	 * this will be replaced with the username supplied by the user.
	 */
	@SuppressWarnings("unchecked")
	public T advancedFilter(java.lang.String value) {
		Object oldValue = this.advancedFilter;
		this.advancedFilter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("advancedFilter", oldValue, value);
		return (T) this;
	}

	/**
	 * Should empty passwords be accepted from the user being authenticated.
	 */
	@ModelNodeBinding(detypedName = "allow-empty-passwords")
	public Boolean allowEmptyPasswords() {
		return this.allowEmptyPasswords;
	}

	/**
	 * Should empty passwords be accepted from the user being authenticated.
	 */
	@SuppressWarnings("unchecked")
	public T allowEmptyPasswords(java.lang.Boolean value) {
		Object oldValue = this.allowEmptyPasswords;
		this.allowEmptyPasswords = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowEmptyPasswords", oldValue, value);
		return (T) this;
	}

	/**
	 * The base distinguished name to commence the search for the user.
	 */
	@ModelNodeBinding(detypedName = "base-dn")
	public String baseDn() {
		return this.baseDn;
	}

	/**
	 * The base distinguished name to commence the search for the user.
	 */
	@SuppressWarnings("unchecked")
	public T baseDn(java.lang.String value) {
		Object oldValue = this.baseDn;
		this.baseDn = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("baseDn", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the connection to use to connect to LDAP.
	 */
	@ModelNodeBinding(detypedName = "connection")
	public String connection() {
		return this.connection;
	}

	/**
	 * The name of the connection to use to connect to LDAP.
	 */
	@SuppressWarnings("unchecked")
	public T connection(java.lang.String value) {
		Object oldValue = this.connection;
		this.connection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connection", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the search should be recursive.
	 */
	@ModelNodeBinding(detypedName = "recursive")
	public Boolean recursive() {
		return this.recursive;
	}

	/**
	 * Whether the search should be recursive.
	 */
	@SuppressWarnings("unchecked")
	public T recursive(java.lang.Boolean value) {
		Object oldValue = this.recursive;
		this.recursive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recursive", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the attribute which is the user's distinguished name.
	 */
	@ModelNodeBinding(detypedName = "user-dn")
	public String userDn() {
		return this.userDn;
	}

	/**
	 * The name of the attribute which is the user's distinguished name.
	 */
	@SuppressWarnings("unchecked")
	public T userDn(java.lang.String value) {
		Object oldValue = this.userDn;
		this.userDn = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("userDn", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the attribute to search for the user. This filter will then
	 * perform a simple search where the username entered by the user matches
	 * the attribute specified here.
	 */
	@ModelNodeBinding(detypedName = "username-attribute")
	public String usernameAttribute() {
		return this.usernameAttribute;
	}

	/**
	 * The name of the attribute to search for the user. This filter will then
	 * perform a simple search where the username entered by the user matches
	 * the attribute specified here.
	 */
	@SuppressWarnings("unchecked")
	public T usernameAttribute(java.lang.String value) {
		Object oldValue = this.usernameAttribute;
		this.usernameAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("usernameAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the attribute that should be loaded from the authenticated
	 * users LDAP entry to replace the username that they supplied, e.g. convert
	 * an e-mail address to an ID or correct the case entered.
	 */
	@ModelNodeBinding(detypedName = "username-load")
	public String usernameLoad() {
		return this.usernameLoad;
	}

	/**
	 * The name of the attribute that should be loaded from the authenticated
	 * users LDAP entry to replace the username that they supplied, e.g. convert
	 * an e-mail address to an ID or correct the case entered.
	 */
	@SuppressWarnings("unchecked")
	public T usernameLoad(java.lang.String value) {
		Object oldValue = this.usernameLoad;
		this.usernameLoad = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("usernameLoad", oldValue, value);
		return (T) this;
	}
}