package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameFilterUsernameToDn;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameFilterUsernameToDnConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameFilterUsernameToDnSupplier;
import org.wildfly.swarm.config.management.security_realm.authorization.GroupToPrincipalGroupSearch;
import org.wildfly.swarm.config.management.security_realm.authorization.GroupToPrincipalGroupSearchConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.GroupToPrincipalGroupSearchSupplier;
import org.wildfly.swarm.config.management.security_realm.authorization.AdvancedFilterUsernameToDn;
import org.wildfly.swarm.config.management.security_realm.authorization.AdvancedFilterUsernameToDnConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.AdvancedFilterUsernameToDnSupplier;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameIsDnUsernameToDn;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameIsDnUsernameToDnConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.UsernameIsDnUsernameToDnSupplier;
import org.wildfly.swarm.config.management.security_realm.authorization.PrincipalToGroupGroupSearch;
import org.wildfly.swarm.config.management.security_realm.authorization.PrincipalToGroupGroupSearchConsumer;
import org.wildfly.swarm.config.management.security_realm.authorization.PrincipalToGroupGroupSearchSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration to use LDAP as the user repository.
 */
@Address("/core-service=management/security-realm=*/authorization=ldap")
@ResourceType("authorization")
@Implicit
public class LdapAuthorization<T extends LdapAuthorization<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private LdapAuthorizationResources subresources = new LdapAuthorizationResources();
	@AttributeDocumentation("The name of the connection to use to connect to LDAP.")
	private String connection;

	public LdapAuthorization() {
		super();
		this.key = "ldap";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public LdapAuthorizationResources subresources() {
		return this.subresources;
	}

	/**
	 * A simple filter configuration to identify the users distinguished name
	 * from their username.
	 */
	@SuppressWarnings("unchecked")
	public T usernameFilterUsernameToDn(UsernameFilterUsernameToDn value) {
		this.subresources.usernameFilterUsernameToDn = value;
		return (T) this;
	}

	/**
	 * A simple filter configuration to identify the users distinguished name
	 * from their username.
	 */
	@SuppressWarnings("unchecked")
	public T usernameFilterUsernameToDn(
			UsernameFilterUsernameToDnConsumer consumer) {
		UsernameFilterUsernameToDn<? extends UsernameFilterUsernameToDn> child = new UsernameFilterUsernameToDn<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.usernameFilterUsernameToDn = child;
		return (T) this;
	}

	/**
	 * A simple filter configuration to identify the users distinguished name
	 * from their username.
	 */
	@SuppressWarnings("unchecked")
	public T usernameFilterUsernameToDn() {
		UsernameFilterUsernameToDn<? extends UsernameFilterUsernameToDn> child = new UsernameFilterUsernameToDn<>();
		this.subresources.usernameFilterUsernameToDn = child;
		return (T) this;
	}

	/**
	 * A simple filter configuration to identify the users distinguished name
	 * from their username.
	 */
	@SuppressWarnings("unchecked")
	public T usernameFilterUsernameToDn(
			UsernameFilterUsernameToDnSupplier supplier) {
		this.subresources.usernameFilterUsernameToDn = supplier.get();
		return (T) this;
	}

	/**
	 * A group search where the group entry contains an attribute referencing
	 * it's members.
	 */
	@SuppressWarnings("unchecked")
	public T groupToPrincipalGroupSearch(GroupToPrincipalGroupSearch value) {
		this.subresources.groupToPrincipalGroupSearch = value;
		return (T) this;
	}

	/**
	 * A group search where the group entry contains an attribute referencing
	 * it's members.
	 */
	@SuppressWarnings("unchecked")
	public T groupToPrincipalGroupSearch(
			GroupToPrincipalGroupSearchConsumer consumer) {
		GroupToPrincipalGroupSearch<? extends GroupToPrincipalGroupSearch> child = new GroupToPrincipalGroupSearch<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.groupToPrincipalGroupSearch = child;
		return (T) this;
	}

	/**
	 * A group search where the group entry contains an attribute referencing
	 * it's members.
	 */
	@SuppressWarnings("unchecked")
	public T groupToPrincipalGroupSearch() {
		GroupToPrincipalGroupSearch<? extends GroupToPrincipalGroupSearch> child = new GroupToPrincipalGroupSearch<>();
		this.subresources.groupToPrincipalGroupSearch = child;
		return (T) this;
	}

	/**
	 * A group search where the group entry contains an attribute referencing
	 * it's members.
	 */
	@SuppressWarnings("unchecked")
	public T groupToPrincipalGroupSearch(
			GroupToPrincipalGroupSearchSupplier supplier) {
		this.subresources.groupToPrincipalGroupSearch = supplier.get();
		return (T) this;
	}

	/**
	 * An advanced filter configuration to identify the users distinguished name
	 * from the username.
	 */
	@SuppressWarnings("unchecked")
	public T advancedFilterUsernameToDn(AdvancedFilterUsernameToDn value) {
		this.subresources.advancedFilterUsernameToDn = value;
		return (T) this;
	}

	/**
	 * An advanced filter configuration to identify the users distinguished name
	 * from the username.
	 */
	@SuppressWarnings("unchecked")
	public T advancedFilterUsernameToDn(
			AdvancedFilterUsernameToDnConsumer consumer) {
		AdvancedFilterUsernameToDn<? extends AdvancedFilterUsernameToDn> child = new AdvancedFilterUsernameToDn<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.advancedFilterUsernameToDn = child;
		return (T) this;
	}

	/**
	 * An advanced filter configuration to identify the users distinguished name
	 * from the username.
	 */
	@SuppressWarnings("unchecked")
	public T advancedFilterUsernameToDn() {
		AdvancedFilterUsernameToDn<? extends AdvancedFilterUsernameToDn> child = new AdvancedFilterUsernameToDn<>();
		this.subresources.advancedFilterUsernameToDn = child;
		return (T) this;
	}

	/**
	 * An advanced filter configuration to identify the users distinguished name
	 * from the username.
	 */
	@SuppressWarnings("unchecked")
	public T advancedFilterUsernameToDn(
			AdvancedFilterUsernameToDnSupplier supplier) {
		this.subresources.advancedFilterUsernameToDn = supplier.get();
		return (T) this;
	}

	/**
	 * User search configuration where the username is already a distinguished
	 * name.
	 */
	@SuppressWarnings("unchecked")
	public T usernameIsDnUsernameToDn(UsernameIsDnUsernameToDn value) {
		this.subresources.usernameIsDnUsernameToDn = value;
		return (T) this;
	}

	/**
	 * User search configuration where the username is already a distinguished
	 * name.
	 */
	@SuppressWarnings("unchecked")
	public T usernameIsDnUsernameToDn(UsernameIsDnUsernameToDnConsumer consumer) {
		UsernameIsDnUsernameToDn<? extends UsernameIsDnUsernameToDn> child = new UsernameIsDnUsernameToDn<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.usernameIsDnUsernameToDn = child;
		return (T) this;
	}

	/**
	 * User search configuration where the username is already a distinguished
	 * name.
	 */
	@SuppressWarnings("unchecked")
	public T usernameIsDnUsernameToDn() {
		UsernameIsDnUsernameToDn<? extends UsernameIsDnUsernameToDn> child = new UsernameIsDnUsernameToDn<>();
		this.subresources.usernameIsDnUsernameToDn = child;
		return (T) this;
	}

	/**
	 * User search configuration where the username is already a distinguished
	 * name.
	 */
	@SuppressWarnings("unchecked")
	public T usernameIsDnUsernameToDn(UsernameIsDnUsernameToDnSupplier supplier) {
		this.subresources.usernameIsDnUsernameToDn = supplier.get();
		return (T) this;
	}

	/**
	 * A group search where the principal entries contain an attribute
	 * referencing the groups that they are a member of.
	 */
	@SuppressWarnings("unchecked")
	public T principalToGroupGroupSearch(PrincipalToGroupGroupSearch value) {
		this.subresources.principalToGroupGroupSearch = value;
		return (T) this;
	}

	/**
	 * A group search where the principal entries contain an attribute
	 * referencing the groups that they are a member of.
	 */
	@SuppressWarnings("unchecked")
	public T principalToGroupGroupSearch(
			PrincipalToGroupGroupSearchConsumer consumer) {
		PrincipalToGroupGroupSearch<? extends PrincipalToGroupGroupSearch> child = new PrincipalToGroupGroupSearch<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.principalToGroupGroupSearch = child;
		return (T) this;
	}

	/**
	 * A group search where the principal entries contain an attribute
	 * referencing the groups that they are a member of.
	 */
	@SuppressWarnings("unchecked")
	public T principalToGroupGroupSearch() {
		PrincipalToGroupGroupSearch<? extends PrincipalToGroupGroupSearch> child = new PrincipalToGroupGroupSearch<>();
		this.subresources.principalToGroupGroupSearch = child;
		return (T) this;
	}

	/**
	 * A group search where the principal entries contain an attribute
	 * referencing the groups that they are a member of.
	 */
	@SuppressWarnings("unchecked")
	public T principalToGroupGroupSearch(
			PrincipalToGroupGroupSearchSupplier supplier) {
		this.subresources.principalToGroupGroupSearch = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for LdapAuthorization
	 */
	public static class LdapAuthorizationResources {
		@SingletonResource
		@ResourceDocumentation("A simple filter configuration to identify the users distinguished name from their username.")
		private UsernameFilterUsernameToDn usernameFilterUsernameToDn;
		@SingletonResource
		@ResourceDocumentation("A group search where the group entry contains an attribute referencing it's members.")
		private GroupToPrincipalGroupSearch groupToPrincipalGroupSearch;
		@SingletonResource
		@ResourceDocumentation("An advanced filter configuration to identify the users distinguished name from the username.")
		private AdvancedFilterUsernameToDn advancedFilterUsernameToDn;
		@SingletonResource
		@ResourceDocumentation("User search configuration where the username is already a distinguished name.")
		private UsernameIsDnUsernameToDn usernameIsDnUsernameToDn;
		@SingletonResource
		@ResourceDocumentation("A group search where the principal entries contain an attribute referencing the groups that they are a member of.")
		private PrincipalToGroupGroupSearch principalToGroupGroupSearch;

		/**
		 * A simple filter configuration to identify the users distinguished
		 * name from their username.
		 */
		@Subresource
		public UsernameFilterUsernameToDn usernameFilterUsernameToDn() {
			return this.usernameFilterUsernameToDn;
		}

		/**
		 * A group search where the group entry contains an attribute
		 * referencing it's members.
		 */
		@Subresource
		public GroupToPrincipalGroupSearch groupToPrincipalGroupSearch() {
			return this.groupToPrincipalGroupSearch;
		}

		/**
		 * An advanced filter configuration to identify the users distinguished
		 * name from the username.
		 */
		@Subresource
		public AdvancedFilterUsernameToDn advancedFilterUsernameToDn() {
			return this.advancedFilterUsernameToDn;
		}

		/**
		 * User search configuration where the username is already a
		 * distinguished name.
		 */
		@Subresource
		public UsernameIsDnUsernameToDn usernameIsDnUsernameToDn() {
			return this.usernameIsDnUsernameToDn;
		}

		/**
		 * A group search where the principal entries contain an attribute
		 * referencing the groups that they are a member of.
		 */
		@Subresource
		public PrincipalToGroupGroupSearch principalToGroupGroupSearch() {
			return this.principalToGroupGroupSearch;
		}
	}

	/**
	 * The name of the connection to use to connect to LDAP.
	 */
	@ModelNodeBinding(detypedName = "connection")
	public String connection() {
		return this.connection;
	}

	/**
	 * The name of the connection to use to connect to LDAP.
	 */
	@SuppressWarnings("unchecked")
	public T connection(java.lang.String value) {
		Object oldValue = this.connection;
		this.connection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connection", oldValue, value);
		return (T) this;
	}
}