package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Configuration of a keystore to use to create a trust manager to verify
 * clients.
 */
@Address("/core-service=management/security-realm=*/authentication=truststore")
@ResourceType("authentication")
@Implicit
public class TruststoreAuthentication<T extends TruststoreAuthentication<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The password to open the keystore.")
	private String keystorePassword;
	@AttributeDocumentation("The reference to credential for the keystore password stored in CredentialStore under defined alias or clear text password.")
	private Map keystorePasswordCredentialReference;
	@AttributeDocumentation("The path of the keystore, will be ignored if the keystore-provider is anything other than JKS.")
	private String keystorePath;
	@AttributeDocumentation("The provider for loading the keystore, defaults to JKS.")
	private String keystoreProvider;
	@AttributeDocumentation("The name of another previously named path, or of one of the standard paths provided by the system. If 'relative-to' is provided, the value of the 'path' attribute is treated as relative to the path specified by this attribute.")
	private String keystoreRelativeTo;

	public TruststoreAuthentication() {
		super();
		this.key = "truststore";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The password to open the keystore.
	 */
	@ModelNodeBinding(detypedName = "keystore-password")
	public String keystorePassword() {
		return this.keystorePassword;
	}

	/**
	 * The password to open the keystore.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePassword(java.lang.String value) {
		Object oldValue = this.keystorePassword;
		this.keystorePassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystorePassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The reference to credential for the keystore password stored in
	 * CredentialStore under defined alias or clear text password.
	 */
	@ModelNodeBinding(detypedName = "keystore-password-credential-reference")
	public Map keystorePasswordCredentialReference() {
		return this.keystorePasswordCredentialReference;
	}

	/**
	 * The reference to credential for the keystore password stored in
	 * CredentialStore under defined alias or clear text password.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePasswordCredentialReference(java.util.Map value) {
		Object oldValue = this.keystorePasswordCredentialReference;
		this.keystorePasswordCredentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystorePasswordCredentialReference",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The reference to credential for the keystore password stored in
	 * CredentialStore under defined alias or clear text password.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePasswordCredentialReference(java.lang.String key,
			java.lang.Object value) {
		if (this.keystorePasswordCredentialReference == null) {
			this.keystorePasswordCredentialReference = new java.util.HashMap<>();
		}
		this.keystorePasswordCredentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The path of the keystore, will be ignored if the keystore-provider is
	 * anything other than JKS.
	 */
	@ModelNodeBinding(detypedName = "keystore-path")
	public String keystorePath() {
		return this.keystorePath;
	}

	/**
	 * The path of the keystore, will be ignored if the keystore-provider is
	 * anything other than JKS.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePath(java.lang.String value) {
		Object oldValue = this.keystorePath;
		this.keystorePath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystorePath", oldValue, value);
		return (T) this;
	}

	/**
	 * The provider for loading the keystore, defaults to JKS.
	 */
	@ModelNodeBinding(detypedName = "keystore-provider")
	public String keystoreProvider() {
		return this.keystoreProvider;
	}

	/**
	 * The provider for loading the keystore, defaults to JKS.
	 */
	@SuppressWarnings("unchecked")
	public T keystoreProvider(java.lang.String value) {
		Object oldValue = this.keystoreProvider;
		this.keystoreProvider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystoreProvider", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@ModelNodeBinding(detypedName = "keystore-relative-to")
	public String keystoreRelativeTo() {
		return this.keystoreRelativeTo;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@SuppressWarnings("unchecked")
	public T keystoreRelativeTo(java.lang.String value) {
		Object oldValue = this.keystoreRelativeTo;
		this.keystoreRelativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystoreRelativeTo", oldValue, value);
		return (T) this;
	}
}