package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorServiceConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorServiceSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorService;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnectionConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnectionSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnection;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroupConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroupSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroup;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.RuntimeQueue;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSettingConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSettingSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.AddressSetting;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueue;
import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.DivertConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.DivertSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Divert;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.InVMAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.DiscoveryGroupConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.DiscoveryGroupSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.DiscoveryGroup;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPConnector;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.AcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.AcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Acceptor;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.RemoteConnector;
import org.wildfly.swarm.config.messaging.activemq.server.InVMConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.InVMConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.InVMConnector;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LegacyConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandlerConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandlerSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.GroupingHandler;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopicConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopicSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopic;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Connector;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySettingConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySettingSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SecuritySetting;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddressConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddressSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.CoreAddress;
import org.wildfly.swarm.config.messaging.activemq.server.BridgeConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BridgeSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Bridge;
import org.wildfly.swarm.config.messaging.activemq.server.QueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.QueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Queue;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreColocatedHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationMasterHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreMasterHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.BindingsDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JournalDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.PagingDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPath;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPathConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LargeMessagesDirectoryPathSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicySupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicy;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicyConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicySupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * An ActiveMQ server instance.
 */
@Address("/subsystem=messaging-activemq/server=*")
@ResourceType("server")
public class Server<T extends Server<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ServerResources subresources = new ServerResources();
	@AttributeDocumentation("Whether the server is active (and accepting connections) or passive (in backup mode, waiting for failover).")
	private Boolean active;
	@AttributeDocumentation("Whether incoming packets on the server should be handed off to a thread from the thread pool for processing. False if they should be handled on the remoting thread.")
	private Boolean asyncConnectionExecutionEnabled;
	@AttributeDocumentation("If set, this will override how long (in ms) to keep a connection alive without receiving a ping.")
	private Long connectionTtlOverride;
	@AttributeDocumentation("The size of the cache for pre-creating message IDs.")
	private Integer idCacheSize;
	@AttributeDocumentation("The list of incoming interceptor classes used by this server.")
	private List<java.util.Map> incomingInterceptors;
	@AttributeDocumentation("The list of outgoing interceptor classes used by this server.")
	private List<java.util.Map> outgoingInterceptors;
	@AttributeDocumentation("The maximum number of concurrent reads allowed on paging")
	private Integer pageMaxConcurrentIo;
	@AttributeDocumentation("Whether the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.")
	private Boolean persistDeliveryCountBeforeDelivery;
	@AttributeDocumentation("Whether IDs are persisted to the journal.")
	private Boolean persistIdCache;
	@AttributeDocumentation("Whether the server will use the file based journal for persistence.")
	private Boolean persistenceEnabled;
	@AttributeDocumentation("The number of threads that the main scheduled thread pool has.")
	private Integer scheduledThreadPoolMaxSize;
	@AttributeDocumentation("Whether this server is started.")
	private Boolean started;
	@AttributeDocumentation("The number of threads that the main thread pool has. -1 means no limit.")
	private Integer threadPoolMaxSize;
	@AttributeDocumentation("The server's version.")
	private String version;
	@AttributeDocumentation("Whether the server supports wild card routing.")
	private Boolean wildCardRoutingEnabled;
	@AttributeDocumentation("Credential (from Credential Store) to authenticate to cluster")
	private Map clusterCredentialReference;
	@AttributeDocumentation("The password used by cluster connections to communicate between the clustered nodes.")
	private String clusterPassword;
	@AttributeDocumentation("The user used by cluster connections to communicate between the clustered nodes.")
	private String clusterUser;
	@AttributeDocumentation("Frequency to sample JVM memory in ms (or -1 to disable memory sampling)")
	private Long memoryMeasureInterval;
	@AttributeDocumentation("Percentage of available memory which if exceeded results in a warning log")
	private Integer memoryWarningThreshold;
	@AttributeDocumentation("Number of pages to add to check the journal performance (only meant to be used to test performance of pages).")
	private Integer perfBlastPages;
	@AttributeDocumentation("Whether on startup to perform a diagnostic test on how fast your disk can sync. Useful when determining performance issues.")
	private Boolean runSyncSpeedTest;
	@AttributeDocumentation("How often to dump basic runtime information to the server log. A value less than 1 disables this feature.")
	private Long serverDumpInterval;
	@AttributeDocumentation("Whether the server should create the bindings directory on start up.")
	private Boolean createBindingsDir;
	@AttributeDocumentation("Whether the server should create the journal directory on start up.")
	private Boolean createJournalDir;
	@AttributeDocumentation("Name of the JDBC table to store the bindings.")
	private String journalBindingsTable;
	@AttributeDocumentation("The size of the internal buffer on the journal.")
	private Long journalBufferSize;
	@AttributeDocumentation("The timeout (in nanoseconds) used to flush internal buffers on the journal.")
	private Long journalBufferTimeout;
	@AttributeDocumentation("The minimal number of journal data files before we can start compacting.")
	private Integer journalCompactMinFiles;
	@AttributeDocumentation("The percentage of live data on which we consider compacting the journal.")
	private Integer journalCompactPercentage;
	@AttributeDocumentation("Type of the database (can be used to customize SQL statements). If this attribute is not specified, the type of the database will be determined based on the DataSource metadata.")
	private String journalDatabase;
	@AttributeDocumentation("Name of the DataSource for the JDBC store.")
	private String journalDatasource;
	@AttributeDocumentation("The size (in bytes) of each journal file.")
	private Long journalFileSize;
	@AttributeDocumentation("The timeout used by the JDBC connection to detect network issues.")
	private Integer journalJdbcNetworkTimeout;
	@AttributeDocumentation("Name of the JDBC table to store the JMS bindings.")
	private String journalJmsBindingsTable;
	@AttributeDocumentation("Name of the JDBC table to store the large messages.")
	private String journalLargeMessagesTable;
	@AttributeDocumentation("The maximum number of write requests that can be in the AIO queue at any one time.")
	private Integer journalMaxIo;
	@AttributeDocumentation("Name of the JDBC table to store the messages.")
	private String journalMessagesTable;
	@AttributeDocumentation("How many journal files to pre-create.")
	private Integer journalMinFiles;
	@AttributeDocumentation("Name of the JDBC table to store pages.")
	private String journalPageStoreTable;
	@AttributeDocumentation("The number of journal files that can be reused. ActiveMQ will create as many files as needed however when reclaiming files it will shrink back to the value (-1 means no limit).")
	private Integer journalPoolFiles;
	@AttributeDocumentation("Whether to wait for non transaction data to be synced to the journal before returning a response to the client.")
	private Boolean journalSyncNonTransactional;
	@AttributeDocumentation("Whether to wait for transaction data to be synchronized to the journal before returning a response to the client.")
	private Boolean journalSyncTransactional;
	@AttributeDocumentation("The type of journal to use.")
	private JournalType journalType;
	@AttributeDocumentation("Whether to periodically log the journal's write rate and flush rate.")
	private Boolean logJournalWriteRate;
	@AttributeDocumentation("The JMX domain used to register internal ActiveMQ MBeans in the MBeanServer.")
	private String jmxDomain;
	@AttributeDocumentation("Whether ActiveMQ should expose its internal management API via JMX. This is not recommended, as accessing these MBeans can lead to inconsistent configuration.")
	private Boolean jmxManagementEnabled;
	@AttributeDocumentation("Address to send management messages to.")
	private String managementAddress;
	@AttributeDocumentation("The name of the address that consumers bind to  to receive management notifications.")
	private String managementNotificationAddress;
	@AttributeDocumentation("How often (in ms) to scan for expired messages.")
	private Long messageExpiryScanPeriod;
	@AttributeDocumentation("The priority of the thread expiring messages.")
	private Integer messageExpiryThreadPriority;
	@AttributeDocumentation("The name of the Elytron security domain used to verify user and role information.")
	private String elytronDomain;
	@AttributeDocumentation("Whether the ActiveMQ server will override security credentials for in-vm connections.")
	private Boolean overrideInVmSecurity;
	@AttributeDocumentation("Whether security is enabled.")
	private Boolean securityEnabled;
	@AttributeDocumentation("How long (in ms) to wait before invalidating the security cache.")
	private Long securityInvalidationInterval;
	@AttributeDocumentation("How many days to keep message counter history.")
	private Integer messageCounterMaxDayHistory;
	@AttributeDocumentation("The sample period (in ms) to use for message counters.")
	private Long messageCounterSamplePeriod;
	@AttributeDocumentation("Whether gathering of statistics such as message counters are enabled.")
	private Boolean statisticsEnabled;
	@AttributeDocumentation("How long (in ms) before a transaction can be removed from the resource manager after create time.")
	private Long transactionTimeout;
	@AttributeDocumentation("How often (in ms) to scan for timeout transactions.")
	private Long transactionTimeoutScanPeriod;

	public Server(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ConnectorService objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConnectorService objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectorServices(java.util.List<ConnectorService> value) {
		this.subresources.connectorServices = value;
		return (T) this;
	}

	/**
	 * Add the ConnectorService object to the list of subresources
	 * 
	 * @param value
	 *            The ConnectorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(ConnectorService value) {
		this.subresources.connectorServices.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectorService object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectorService resource
	 * @param config
	 *            The ConnectorServiceConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(java.lang.String childKey,
			ConnectorServiceConsumer consumer) {
		ConnectorService<? extends ConnectorService> child = new ConnectorService<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connectorService(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectorService object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectorService resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(java.lang.String childKey) {
		connectorService(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConnectorService object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(ConnectorServiceSupplier supplier) {
		connectorService(supplier.get());
		return (T) this;
	}

	/**
	 * Add all HTTPAcceptor objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HTTPAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptors(java.util.List<HTTPAcceptor> value) {
		this.subresources.httpAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the HTTPAcceptor object to the list of subresources
	 * 
	 * @param value
	 *            The HTTPAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(HTTPAcceptor value) {
		this.subresources.httpAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPAcceptor resource
	 * @param config
	 *            The HTTPAcceptorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(java.lang.String childKey,
			HTTPAcceptorConsumer consumer) {
		HTTPAcceptor<? extends HTTPAcceptor> child = new HTTPAcceptor<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(java.lang.String childKey) {
		httpAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HTTPAcceptor object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(HTTPAcceptorSupplier supplier) {
		httpAcceptor(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ClusterConnection objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ClusterConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnections(java.util.List<ClusterConnection> value) {
		this.subresources.clusterConnections = value;
		return (T) this;
	}

	/**
	 * Add the ClusterConnection object to the list of subresources
	 * 
	 * @param value
	 *            The ClusterConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(ClusterConnection value) {
		this.subresources.clusterConnections.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ClusterConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ClusterConnection resource
	 * @param config
	 *            The ClusterConnectionConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(java.lang.String childKey,
			ClusterConnectionConsumer consumer) {
		ClusterConnection<? extends ClusterConnection> child = new ClusterConnection<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		clusterConnection(child);
		return (T) this;
	}

	/**
	 * Create and configure a ClusterConnection object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ClusterConnection resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(java.lang.String childKey) {
		clusterConnection(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ClusterConnection object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(ClusterConnectionSupplier supplier) {
		clusterConnection(supplier.get());
		return (T) this;
	}

	/**
	 * Add all BroadcastGroup objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of BroadcastGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroups(java.util.List<BroadcastGroup> value) {
		this.subresources.broadcastGroups = value;
		return (T) this;
	}

	/**
	 * Add the BroadcastGroup object to the list of subresources
	 * 
	 * @param value
	 *            The BroadcastGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(BroadcastGroup value) {
		this.subresources.broadcastGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a BroadcastGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the BroadcastGroup resource
	 * @param config
	 *            The BroadcastGroupConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(java.lang.String childKey,
			BroadcastGroupConsumer consumer) {
		BroadcastGroup<? extends BroadcastGroup> child = new BroadcastGroup<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		broadcastGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a BroadcastGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the BroadcastGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(java.lang.String childKey) {
		broadcastGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied BroadcastGroup object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(BroadcastGroupSupplier supplier) {
		broadcastGroup(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RuntimeQueue objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RuntimeQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueues(java.util.List<RuntimeQueue> value) {
		this.subresources.runtimeQueues = value;
		return (T) this;
	}

	/**
	 * Add the RuntimeQueue object to the list of subresources
	 * 
	 * @param value
	 *            The RuntimeQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(RuntimeQueue value) {
		this.subresources.runtimeQueues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RuntimeQueue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RuntimeQueue resource
	 * @param config
	 *            The RuntimeQueueConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(java.lang.String childKey,
			RuntimeQueueConsumer consumer) {
		RuntimeQueue<? extends RuntimeQueue> child = new RuntimeQueue<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		runtimeQueue(child);
		return (T) this;
	}

	/**
	 * Create and configure a RuntimeQueue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RuntimeQueue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(java.lang.String childKey) {
		runtimeQueue(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RuntimeQueue object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(RuntimeQueueSupplier supplier) {
		runtimeQueue(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AddressSetting objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AddressSetting objects.
	 */
	@SuppressWarnings("unchecked")
	public T addressSettings(java.util.List<AddressSetting> value) {
		this.subresources.addressSettings = value;
		return (T) this;
	}

	/**
	 * Add the AddressSetting object to the list of subresources
	 * 
	 * @param value
	 *            The AddressSetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(AddressSetting value) {
		this.subresources.addressSettings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AddressSetting object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AddressSetting resource
	 * @param config
	 *            The AddressSettingConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(java.lang.String childKey,
			AddressSettingConsumer consumer) {
		AddressSetting<? extends AddressSetting> child = new AddressSetting<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		addressSetting(child);
		return (T) this;
	}

	/**
	 * Create and configure a AddressSetting object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AddressSetting resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(java.lang.String childKey) {
		addressSetting(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AddressSetting object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(AddressSettingSupplier supplier) {
		addressSetting(supplier.get());
		return (T) this;
	}

	/**
	 * Add all JMSQueue objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of JMSQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueues(java.util.List<JMSQueue> value) {
		this.subresources.jmsQueues = value;
		return (T) this;
	}

	/**
	 * Add the JMSQueue object to the list of subresources
	 * 
	 * @param value
	 *            The JMSQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(JMSQueue value) {
		this.subresources.jmsQueues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a JMSQueue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSQueue resource
	 * @param config
	 *            The JMSQueueConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(java.lang.String childKey, JMSQueueConsumer consumer) {
		JMSQueue<? extends JMSQueue> child = new JMSQueue<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		jmsQueue(child);
		return (T) this;
	}

	/**
	 * Create and configure a JMSQueue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSQueue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(java.lang.String childKey) {
		jmsQueue(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied JMSQueue object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(JMSQueueSupplier supplier) {
		jmsQueue(supplier.get());
		return (T) this;
	}

	/**
	 * Add all PooledConnectionFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of PooledConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactories(
			java.util.List<PooledConnectionFactory> value) {
		this.subresources.pooledConnectionFactories = value;
		return (T) this;
	}

	/**
	 * Add the PooledConnectionFactory object to the list of subresources
	 * 
	 * @param value
	 *            The PooledConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(PooledConnectionFactory value) {
		this.subresources.pooledConnectionFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a PooledConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PooledConnectionFactory resource
	 * @param config
	 *            The PooledConnectionFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(java.lang.String childKey,
			PooledConnectionFactoryConsumer consumer) {
		PooledConnectionFactory<? extends PooledConnectionFactory> child = new PooledConnectionFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		pooledConnectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a PooledConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the PooledConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(java.lang.String childKey) {
		pooledConnectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied PooledConnectionFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(PooledConnectionFactorySupplier supplier) {
		pooledConnectionFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Divert objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Divert objects.
	 */
	@SuppressWarnings("unchecked")
	public T diverts(java.util.List<Divert> value) {
		this.subresources.diverts = value;
		return (T) this;
	}

	/**
	 * Add the Divert object to the list of subresources
	 * 
	 * @param value
	 *            The Divert to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(Divert value) {
		this.subresources.diverts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Divert object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Divert resource
	 * @param config
	 *            The DivertConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(java.lang.String childKey, DivertConsumer consumer) {
		Divert<? extends Divert> child = new Divert<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		divert(child);
		return (T) this;
	}

	/**
	 * Create and configure a Divert object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Divert resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(java.lang.String childKey) {
		divert(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Divert object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T divert(DivertSupplier supplier) {
		divert(supplier.get());
		return (T) this;
	}

	/**
	 * Add all InVMAcceptor objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of InVMAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptors(java.util.List<InVMAcceptor> value) {
		this.subresources.inVmAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the InVMAcceptor object to the list of subresources
	 * 
	 * @param value
	 *            The InVMAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(InVMAcceptor value) {
		this.subresources.inVmAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a InVMAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMAcceptor resource
	 * @param config
	 *            The InVMAcceptorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(java.lang.String childKey,
			InVMAcceptorConsumer consumer) {
		InVMAcceptor<? extends InVMAcceptor> child = new InVMAcceptor<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		inVmAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a InVMAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(java.lang.String childKey) {
		inVmAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied InVMAcceptor object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(InVMAcceptorSupplier supplier) {
		inVmAcceptor(supplier.get());
		return (T) this;
	}

	/**
	 * Add all DiscoveryGroup objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of DiscoveryGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroups(java.util.List<DiscoveryGroup> value) {
		this.subresources.discoveryGroups = value;
		return (T) this;
	}

	/**
	 * Add the DiscoveryGroup object to the list of subresources
	 * 
	 * @param value
	 *            The DiscoveryGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(DiscoveryGroup value) {
		this.subresources.discoveryGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a DiscoveryGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the DiscoveryGroup resource
	 * @param config
	 *            The DiscoveryGroupConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String childKey,
			DiscoveryGroupConsumer consumer) {
		DiscoveryGroup<? extends DiscoveryGroup> child = new DiscoveryGroup<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		discoveryGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a DiscoveryGroup object to the list of subresources
	 * 
	 * @param key
	 *            The key for the DiscoveryGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String childKey) {
		discoveryGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied DiscoveryGroup object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(DiscoveryGroupSupplier supplier) {
		discoveryGroup(supplier.get());
		return (T) this;
	}

	/**
	 * Add all HTTPConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of HTTPConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpConnectors(java.util.List<HTTPConnector> value) {
		this.subresources.httpConnectors = value;
		return (T) this;
	}

	/**
	 * Add the HTTPConnector object to the list of subresources
	 * 
	 * @param value
	 *            The HTTPConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnector value) {
		this.subresources.httpConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPConnector resource
	 * @param config
	 *            The HTTPConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(java.lang.String childKey,
			HTTPConnectorConsumer consumer) {
		HTTPConnector<? extends HTTPConnector> child = new HTTPConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		httpConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a HTTPConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the HTTPConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(java.lang.String childKey) {
		httpConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied HTTPConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HTTPConnectorSupplier supplier) {
		httpConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConnectionFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactories(java.util.List<ConnectionFactory> value) {
		this.subresources.connectionFactories = value;
		return (T) this;
	}

	/**
	 * Add the ConnectionFactory object to the list of subresources
	 * 
	 * @param value
	 *            The ConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(ConnectionFactory value) {
		this.subresources.connectionFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectionFactory resource
	 * @param config
	 *            The ConnectionFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(java.lang.String childKey,
			ConnectionFactoryConsumer consumer) {
		ConnectionFactory<? extends ConnectionFactory> child = new ConnectionFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(java.lang.String childKey) {
		connectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConnectionFactory object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(ConnectionFactorySupplier supplier) {
		connectionFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Acceptor objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Acceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T acceptors(java.util.List<Acceptor> value) {
		this.subresources.acceptors = value;
		return (T) this;
	}

	/**
	 * Add the Acceptor object to the list of subresources
	 * 
	 * @param value
	 *            The Acceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(Acceptor value) {
		this.subresources.acceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Acceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Acceptor resource
	 * @param config
	 *            The AcceptorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(java.lang.String childKey, AcceptorConsumer consumer) {
		Acceptor<? extends Acceptor> child = new Acceptor<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		acceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a Acceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Acceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(java.lang.String childKey) {
		acceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Acceptor object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(AcceptorSupplier supplier) {
		acceptor(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemoteAcceptor objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptors(java.util.List<RemoteAcceptor> value) {
		this.subresources.remoteAcceptors = value;
		return (T) this;
	}

	/**
	 * Add the RemoteAcceptor object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(RemoteAcceptor value) {
		this.subresources.remoteAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteAcceptor resource
	 * @param config
	 *            The RemoteAcceptorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(java.lang.String childKey,
			RemoteAcceptorConsumer consumer) {
		RemoteAcceptor<? extends RemoteAcceptor> child = new RemoteAcceptor<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteAcceptor(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteAcceptor object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteAcceptor resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(java.lang.String childKey) {
		remoteAcceptor(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteAcceptor object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(RemoteAcceptorSupplier supplier) {
		remoteAcceptor(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemoteConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnectors(java.util.List<RemoteConnector> value) {
		this.subresources.remoteConnectors = value;
		return (T) this;
	}

	/**
	 * Add the RemoteConnector object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(RemoteConnector value) {
		this.subresources.remoteConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteConnector resource
	 * @param config
	 *            The RemoteConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(java.lang.String childKey,
			RemoteConnectorConsumer consumer) {
		RemoteConnector<? extends RemoteConnector> child = new RemoteConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(java.lang.String childKey) {
		remoteConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(RemoteConnectorSupplier supplier) {
		remoteConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all InVMConnector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of InVMConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnectors(java.util.List<InVMConnector> value) {
		this.subresources.inVmConnectors = value;
		return (T) this;
	}

	/**
	 * Add the InVMConnector object to the list of subresources
	 * 
	 * @param value
	 *            The InVMConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(InVMConnector value) {
		this.subresources.inVmConnectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a InVMConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMConnector resource
	 * @param config
	 *            The InVMConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(java.lang.String childKey,
			InVMConnectorConsumer consumer) {
		InVMConnector<? extends InVMConnector> child = new InVMConnector<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		inVmConnector(child);
		return (T) this;
	}

	/**
	 * Create and configure a InVMConnector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the InVMConnector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(java.lang.String childKey) {
		inVmConnector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied InVMConnector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(InVMConnectorSupplier supplier) {
		inVmConnector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LegacyConnectionFactory objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LegacyConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactories(
			java.util.List<LegacyConnectionFactory> value) {
		this.subresources.legacyConnectionFactories = value;
		return (T) this;
	}

	/**
	 * Add the LegacyConnectionFactory object to the list of subresources
	 * 
	 * @param value
	 *            The LegacyConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(LegacyConnectionFactory value) {
		this.subresources.legacyConnectionFactories.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LegacyConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LegacyConnectionFactory resource
	 * @param config
	 *            The LegacyConnectionFactoryConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(java.lang.String childKey,
			LegacyConnectionFactoryConsumer consumer) {
		LegacyConnectionFactory<? extends LegacyConnectionFactory> child = new LegacyConnectionFactory<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		legacyConnectionFactory(child);
		return (T) this;
	}

	/**
	 * Create and configure a LegacyConnectionFactory object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LegacyConnectionFactory resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(java.lang.String childKey) {
		legacyConnectionFactory(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LegacyConnectionFactory object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(LegacyConnectionFactorySupplier supplier) {
		legacyConnectionFactory(supplier.get());
		return (T) this;
	}

	/**
	 * Add all GroupingHandler objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of GroupingHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandlers(java.util.List<GroupingHandler> value) {
		this.subresources.groupingHandlers = value;
		return (T) this;
	}

	/**
	 * Add the GroupingHandler object to the list of subresources
	 * 
	 * @param value
	 *            The GroupingHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(GroupingHandler value) {
		this.subresources.groupingHandlers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a GroupingHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the GroupingHandler resource
	 * @param config
	 *            The GroupingHandlerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(java.lang.String childKey,
			GroupingHandlerConsumer consumer) {
		GroupingHandler<? extends GroupingHandler> child = new GroupingHandler<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		groupingHandler(child);
		return (T) this;
	}

	/**
	 * Create and configure a GroupingHandler object to the list of subresources
	 * 
	 * @param key
	 *            The key for the GroupingHandler resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(java.lang.String childKey) {
		groupingHandler(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied GroupingHandler object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(GroupingHandlerSupplier supplier) {
		groupingHandler(supplier.get());
		return (T) this;
	}

	/**
	 * Add all JMSTopic objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of JMSTopic objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopics(java.util.List<JMSTopic> value) {
		this.subresources.jmsTopics = value;
		return (T) this;
	}

	/**
	 * Add the JMSTopic object to the list of subresources
	 * 
	 * @param value
	 *            The JMSTopic to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(JMSTopic value) {
		this.subresources.jmsTopics.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a JMSTopic object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSTopic resource
	 * @param config
	 *            The JMSTopicConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(java.lang.String childKey, JMSTopicConsumer consumer) {
		JMSTopic<? extends JMSTopic> child = new JMSTopic<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		jmsTopic(child);
		return (T) this;
	}

	/**
	 * Create and configure a JMSTopic object to the list of subresources
	 * 
	 * @param key
	 *            The key for the JMSTopic resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(java.lang.String childKey) {
		jmsTopic(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied JMSTopic object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(JMSTopicSupplier supplier) {
		jmsTopic(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Connector objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(java.util.List<Connector> value) {
		this.subresources.connectors = value;
		return (T) this;
	}

	/**
	 * Add the Connector object to the list of subresources
	 * 
	 * @param value
	 *            The Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(Connector value) {
		this.subresources.connectors.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Connector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Connector resource
	 * @param config
	 *            The ConnectorConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(java.lang.String childKey, ConnectorConsumer consumer) {
		Connector<? extends Connector> child = new Connector<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connector(child);
		return (T) this;
	}

	/**
	 * Create and configure a Connector object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Connector resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(java.lang.String childKey) {
		connector(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Connector object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T connector(ConnectorSupplier supplier) {
		connector(supplier.get());
		return (T) this;
	}

	/**
	 * Add all SecuritySetting objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SecuritySetting objects.
	 */
	@SuppressWarnings("unchecked")
	public T securitySettings(java.util.List<SecuritySetting> value) {
		this.subresources.securitySettings = value;
		return (T) this;
	}

	/**
	 * Add the SecuritySetting object to the list of subresources
	 * 
	 * @param value
	 *            The SecuritySetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(SecuritySetting value) {
		this.subresources.securitySettings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SecuritySetting object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecuritySetting resource
	 * @param config
	 *            The SecuritySettingConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(java.lang.String childKey,
			SecuritySettingConsumer consumer) {
		SecuritySetting<? extends SecuritySetting> child = new SecuritySetting<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		securitySetting(child);
		return (T) this;
	}

	/**
	 * Create and configure a SecuritySetting object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SecuritySetting resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(java.lang.String childKey) {
		securitySetting(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SecuritySetting object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(SecuritySettingSupplier supplier) {
		securitySetting(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CoreAddress objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CoreAddress objects.
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(java.util.List<CoreAddress> value) {
		this.subresources.coreAddress = value;
		return (T) this;
	}

	/**
	 * Add the CoreAddress object to the list of subresources
	 * 
	 * @param value
	 *            The CoreAddress to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(CoreAddress value) {
		this.subresources.coreAddress.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CoreAddress object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CoreAddress resource
	 * @param config
	 *            The CoreAddressConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(java.lang.String childKey, CoreAddressConsumer consumer) {
		CoreAddress<? extends CoreAddress> child = new CoreAddress<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		coreAddress(child);
		return (T) this;
	}

	/**
	 * Create and configure a CoreAddress object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CoreAddress resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(java.lang.String childKey) {
		coreAddress(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CoreAddress object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(CoreAddressSupplier supplier) {
		coreAddress(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Bridge objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Bridge objects.
	 */
	@SuppressWarnings("unchecked")
	public T bridges(java.util.List<Bridge> value) {
		this.subresources.bridges = value;
		return (T) this;
	}

	/**
	 * Add the Bridge object to the list of subresources
	 * 
	 * @param value
	 *            The Bridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(Bridge value) {
		this.subresources.bridges.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Bridge object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Bridge resource
	 * @param config
	 *            The BridgeConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(java.lang.String childKey, BridgeConsumer consumer) {
		Bridge<? extends Bridge> child = new Bridge<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		bridge(child);
		return (T) this;
	}

	/**
	 * Create and configure a Bridge object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Bridge resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(java.lang.String childKey) {
		bridge(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Bridge object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T bridge(BridgeSupplier supplier) {
		bridge(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Queue objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Queue objects.
	 */
	@SuppressWarnings("unchecked")
	public T queues(java.util.List<Queue> value) {
		this.subresources.queues = value;
		return (T) this;
	}

	/**
	 * Add the Queue object to the list of subresources
	 * 
	 * @param value
	 *            The Queue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(Queue value) {
		this.subresources.queues.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Queue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Queue resource
	 * @param config
	 *            The QueueConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(java.lang.String childKey, QueueConsumer consumer) {
		Queue<? extends Queue> child = new Queue<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		queue(child);
		return (T) this;
	}

	/**
	 * Create and configure a Queue object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Queue resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(java.lang.String childKey) {
		queue(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Queue object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T queue(QueueSupplier supplier) {
		queue(supplier.get());
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy(SharedStoreColocatedHAPolicy value) {
		this.subresources.sharedStoreColocatedHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy(
			SharedStoreColocatedHAPolicyConsumer consumer) {
		SharedStoreColocatedHAPolicy<? extends SharedStoreColocatedHAPolicy> child = new SharedStoreColocatedHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.sharedStoreColocatedHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy() {
		SharedStoreColocatedHAPolicy<? extends SharedStoreColocatedHAPolicy> child = new SharedStoreColocatedHAPolicy<>();
		this.subresources.sharedStoreColocatedHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreColocatedHaPolicy(
			SharedStoreColocatedHAPolicySupplier supplier) {
		this.subresources.sharedStoreColocatedHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy(ReplicationMasterHAPolicy value) {
		this.subresources.replicationMasterHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy(
			ReplicationMasterHAPolicyConsumer consumer) {
		ReplicationMasterHAPolicy<? extends ReplicationMasterHAPolicy> child = new ReplicationMasterHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.replicationMasterHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy() {
		ReplicationMasterHAPolicy<? extends ReplicationMasterHAPolicy> child = new ReplicationMasterHAPolicy<>();
		this.subresources.replicationMasterHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationMasterHaPolicy(
			ReplicationMasterHAPolicySupplier supplier) {
		this.subresources.replicationMasterHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy(SharedStoreMasterHAPolicy value) {
		this.subresources.sharedStoreMasterHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy(
			SharedStoreMasterHAPolicyConsumer consumer) {
		SharedStoreMasterHAPolicy<? extends SharedStoreMasterHAPolicy> child = new SharedStoreMasterHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.sharedStoreMasterHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy() {
		SharedStoreMasterHAPolicy<? extends SharedStoreMasterHAPolicy> child = new SharedStoreMasterHAPolicy<>();
		this.subresources.sharedStoreMasterHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreMasterHaPolicy(
			SharedStoreMasterHAPolicySupplier supplier) {
		this.subresources.sharedStoreMasterHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath(BindingsDirectoryPath value) {
		this.subresources.bindingsDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath(BindingsDirectoryPathConsumer consumer) {
		BindingsDirectoryPath<? extends BindingsDirectoryPath> child = new BindingsDirectoryPath<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.bindingsDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath() {
		BindingsDirectoryPath<? extends BindingsDirectoryPath> child = new BindingsDirectoryPath<>();
		this.subresources.bindingsDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T bindingsDirectoryPath(BindingsDirectoryPathSupplier supplier) {
		this.subresources.bindingsDirectoryPath = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy(ReplicationColocatedHAPolicy value) {
		this.subresources.replicationColocatedHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy(
			ReplicationColocatedHAPolicyConsumer consumer) {
		ReplicationColocatedHAPolicy<? extends ReplicationColocatedHAPolicy> child = new ReplicationColocatedHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.replicationColocatedHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy() {
		ReplicationColocatedHAPolicy<? extends ReplicationColocatedHAPolicy> child = new ReplicationColocatedHAPolicy<>();
		this.subresources.replicationColocatedHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationColocatedHaPolicy(
			ReplicationColocatedHAPolicySupplier supplier) {
		this.subresources.replicationColocatedHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath(JournalDirectoryPath value) {
		this.subresources.journalDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath(JournalDirectoryPathConsumer consumer) {
		JournalDirectoryPath<? extends JournalDirectoryPath> child = new JournalDirectoryPath<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.journalDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath() {
		JournalDirectoryPath<? extends JournalDirectoryPath> child = new JournalDirectoryPath<>();
		this.subresources.journalDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T journalDirectoryPath(JournalDirectoryPathSupplier supplier) {
		this.subresources.journalDirectoryPath = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicy value) {
		this.subresources.sharedStoreSlaveHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicyConsumer consumer) {
		SharedStoreSlaveHAPolicy<? extends SharedStoreSlaveHAPolicy> child = new SharedStoreSlaveHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.sharedStoreSlaveHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy() {
		SharedStoreSlaveHAPolicy<? extends SharedStoreSlaveHAPolicy> child = new SharedStoreSlaveHAPolicy<>();
		this.subresources.sharedStoreSlaveHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T sharedStoreSlaveHaPolicy(SharedStoreSlaveHAPolicySupplier supplier) {
		this.subresources.sharedStoreSlaveHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath(PagingDirectoryPath value) {
		this.subresources.pagingDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath(PagingDirectoryPathConsumer consumer) {
		PagingDirectoryPath<? extends PagingDirectoryPath> child = new PagingDirectoryPath<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.pagingDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath() {
		PagingDirectoryPath<? extends PagingDirectoryPath> child = new PagingDirectoryPath<>();
		this.subresources.pagingDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pagingDirectoryPath(PagingDirectoryPathSupplier supplier) {
		this.subresources.pagingDirectoryPath = supplier.get();
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath(LargeMessagesDirectoryPath value) {
		this.subresources.largeMessagesDirectoryPath = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath(
			LargeMessagesDirectoryPathConsumer consumer) {
		LargeMessagesDirectoryPath<? extends LargeMessagesDirectoryPath> child = new LargeMessagesDirectoryPath<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.largeMessagesDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath() {
		LargeMessagesDirectoryPath<? extends LargeMessagesDirectoryPath> child = new LargeMessagesDirectoryPath<>();
		this.subresources.largeMessagesDirectoryPath = child;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores
	 * persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T largeMessagesDirectoryPath(
			LargeMessagesDirectoryPathSupplier supplier) {
		this.subresources.largeMessagesDirectoryPath = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy(LiveOnlyHAPolicy value) {
		this.subresources.liveOnlyHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy(LiveOnlyHAPolicyConsumer consumer) {
		LiveOnlyHAPolicy<? extends LiveOnlyHAPolicy> child = new LiveOnlyHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.liveOnlyHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy() {
		LiveOnlyHAPolicy<? extends LiveOnlyHAPolicy> child = new LiveOnlyHAPolicy<>();
		this.subresources.liveOnlyHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T liveOnlyHaPolicy(LiveOnlyHAPolicySupplier supplier) {
		this.subresources.liveOnlyHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicy value) {
		this.subresources.replicationSlaveHaPolicy = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicyConsumer consumer) {
		ReplicationSlaveHAPolicy<? extends ReplicationSlaveHAPolicy> child = new ReplicationSlaveHAPolicy<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.replicationSlaveHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy() {
		ReplicationSlaveHAPolicy<? extends ReplicationSlaveHAPolicy> child = new ReplicationSlaveHAPolicy<>();
		this.subresources.replicationSlaveHaPolicy = child;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for
	 * the ActiveMQ server (the value of ha-policy can be live-only,
	 * replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T replicationSlaveHaPolicy(ReplicationSlaveHAPolicySupplier supplier) {
		this.subresources.replicationSlaveHaPolicy = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Server
	 */
	public static class ServerResources {
		/**
		 * A connector service allows to integrate external components with
		 * Apache ActiveMQ Artemis to send and receive messages.
		 */
		@ResourceDocumentation("A connector service allows to integrate external components with Apache ActiveMQ Artemis to send and receive messages.")
		@SubresourceInfo("connectorService")
		private List<ConnectorService> connectorServices = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ
		 * server over HTTP.
		 */
		@ResourceDocumentation("Defines a way in which remote connections can be made to the ActiveMQ server over HTTP.")
		@SubresourceInfo("httpAcceptor")
		private List<HTTPAcceptor> httpAcceptors = new java.util.ArrayList<>();
		/**
		 * Cluster connections group servers into clusters so that messages can
		 * be load balanced between the nodes of the cluster.
		 */
		@ResourceDocumentation("Cluster connections group servers into clusters so that messages can be load balanced between the nodes of the cluster.")
		@SubresourceInfo("clusterConnection")
		private List<ClusterConnection> clusterConnections = new java.util.ArrayList<>();
		/**
		 * A broadcast group is the means by which a server broadcasts
		 * connectors over the network.
		 */
		@ResourceDocumentation("A broadcast group is the means by which a server broadcasts connectors over the network.")
		@SubresourceInfo("broadcastGroup")
		private List<BroadcastGroup> broadcastGroups = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		@ResourceDocumentation("A Queue.")
		@SubresourceInfo("runtimeQueue")
		private List<RuntimeQueue> runtimeQueues = new java.util.ArrayList<>();
		/**
		 * An address setting defines some attributes that are defined against
		 * an address wildcard rather than a specific queue.
		 */
		@ResourceDocumentation("An address setting defines some attributes that are defined against an address wildcard rather than a specific queue.")
		@SubresourceInfo("addressSetting")
		private List<AddressSetting> addressSettings = new java.util.ArrayList<>();
		/**
		 * Defines a JMS queue.
		 */
		@ResourceDocumentation("Defines a JMS queue.")
		@SubresourceInfo("jmsQueue")
		private List<JMSQueue> jmsQueues = new java.util.ArrayList<>();
		/**
		 * Defines a managed connection factory.
		 */
		@ResourceDocumentation("Defines a managed connection factory.")
		@SubresourceInfo("pooledConnectionFactory")
		private List<PooledConnectionFactory> pooledConnectionFactories = new java.util.ArrayList<>();
		/**
		 * A messaging resource that allows you to transparently divert messages
		 * routed to one address to some other address, without making any
		 * changes to any client application logic.
		 */
		@ResourceDocumentation("A messaging resource that allows you to transparently divert messages routed to one address to some other address, without making any changes to any client application logic.")
		@SubresourceInfo("divert")
		private List<Divert> diverts = new java.util.ArrayList<>();
		/**
		 * Defines a way in which in-VM connections can be made to the ActiveMQ
		 * server.
		 */
		@ResourceDocumentation("Defines a way in which in-VM connections can be made to the ActiveMQ server.")
		@SubresourceInfo("inVmAcceptor")
		private List<InVMAcceptor> inVmAcceptors = new java.util.ArrayList<>();
		/**
		 * Multicast group to listen to receive broadcast from other servers
		 * announcing their connectors.
		 */
		@ResourceDocumentation("Multicast group to listen to receive broadcast from other servers announcing their connectors.")
		@SubresourceInfo("discoveryGroup")
		private List<DiscoveryGroup> discoveryGroups = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server over
		 * HTTP.
		 */
		@ResourceDocumentation("Used by a remote client to define how it connects to a server over HTTP.")
		@SubresourceInfo("httpConnector")
		private List<HTTPConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		@ResourceDocumentation("Defines a connection factory.")
		@SubresourceInfo("connectionFactory")
		private List<ConnectionFactory> connectionFactories = new java.util.ArrayList<>();
		/**
		 * An acceptor defines a way in which connections can be made to the
		 * ActiveMQ server.
		 */
		@ResourceDocumentation("An acceptor defines a way in which connections can be made to the ActiveMQ server.")
		@SubresourceInfo("acceptor")
		private List<Acceptor> acceptors = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ
		 * server.
		 */
		@ResourceDocumentation("Defines a way in which remote connections can be made to the ActiveMQ server.")
		@SubresourceInfo("remoteAcceptor")
		private List<RemoteAcceptor> remoteAcceptors = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server.
		 */
		@ResourceDocumentation("Used by a remote client to define how it connects to a server.")
		@SubresourceInfo("remoteConnector")
		private List<RemoteConnector> remoteConnectors = new java.util.ArrayList<>();
		/**
		 * Used by an in-VM client to define how it connects to a server.
		 */
		@ResourceDocumentation("Used by an in-VM client to define how it connects to a server.")
		@SubresourceInfo("inVmConnector")
		private List<InVMConnector> inVmConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		@ResourceDocumentation("Defines a connection factory.")
		@SubresourceInfo("legacyConnectionFactory")
		private List<LegacyConnectionFactory> legacyConnectionFactories = new java.util.ArrayList<>();
		/**
		 * Makes decisions about which node in a cluster should handle a message
		 * with a group id assigned.
		 */
		@ResourceDocumentation("Makes decisions about which node in a cluster should handle a message with a group id assigned.")
		@SubresourceInfo("groupingHandler")
		private List<GroupingHandler> groupingHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a JMS topic.
		 */
		@ResourceDocumentation("Defines a JMS topic.")
		@SubresourceInfo("jmsTopic")
		private List<JMSTopic> jmsTopics = new java.util.ArrayList<>();
		/**
		 * A connector can be used by a client to define how it connects to a
		 * server.
		 */
		@ResourceDocumentation("A connector can be used by a client to define how it connects to a server.")
		@SubresourceInfo("connector")
		private List<Connector> connectors = new java.util.ArrayList<>();
		/**
		 * A security setting allows sets of permissions to be defined against
		 * queues based on their address.
		 */
		@ResourceDocumentation("A security setting allows sets of permissions to be defined against queues based on their address.")
		@SubresourceInfo("securitySetting")
		private List<SecuritySetting> securitySettings = new java.util.ArrayList<>();
		/**
		 * A runtime-only resource representing a ActiveMQ "address". Zero or
		 * more queues can be bound to a single address. When a message is
		 * routed, it is routed to the set of queues bound to the message's
		 * address.
		 */
		@ResourceDocumentation("A runtime-only resource representing a ActiveMQ \"address\". Zero or more queues can be bound to a single address. When a message is routed, it is routed to the set of queues bound to the message's address.")
		@SubresourceInfo("coreAddress")
		private List<CoreAddress> coreAddress = new java.util.ArrayList<>();
		/**
		 * The function of a bridge is to consume messages from a source queue,
		 * and forward them to a target address, typically on a different
		 * ActiveMQ server.
		 */
		@ResourceDocumentation("The function of a bridge is to consume messages from a source queue, and forward them to a target address, typically on a different ActiveMQ server.")
		@SubresourceInfo("bridge")
		private List<Bridge> bridges = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		@ResourceDocumentation("A Queue.")
		@SubresourceInfo("queue")
		private List<Queue> queues = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
		private SharedStoreColocatedHAPolicy sharedStoreColocatedHaPolicy;
		@SingletonResource
		@ResourceDocumentation("A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
		private ReplicationMasterHAPolicy replicationMasterHaPolicy;
		@SingletonResource
		@ResourceDocumentation("A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
		private SharedStoreMasterHAPolicy sharedStoreMasterHaPolicy;
		@SingletonResource
		@ResourceDocumentation("A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.")
		private BindingsDirectoryPath bindingsDirectoryPath;
		@SingletonResource
		@ResourceDocumentation("A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
		private ReplicationColocatedHAPolicy replicationColocatedHaPolicy;
		@SingletonResource
		@ResourceDocumentation("A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.")
		private JournalDirectoryPath journalDirectoryPath;
		@SingletonResource
		@ResourceDocumentation("A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
		private SharedStoreSlaveHAPolicy sharedStoreSlaveHaPolicy;
		@SingletonResource
		@ResourceDocumentation("A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.")
		private PagingDirectoryPath pagingDirectoryPath;
		@SingletonResource
		@ResourceDocumentation("A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.")
		private LargeMessagesDirectoryPath largeMessagesDirectoryPath;
		@SingletonResource
		@ResourceDocumentation("A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
		private LiveOnlyHAPolicy liveOnlyHaPolicy;
		@SingletonResource
		@ResourceDocumentation("A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).")
		private ReplicationSlaveHAPolicy replicationSlaveHaPolicy;

		/**
		 * Get the list of ConnectorService resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectorService> connectorServices() {
			return this.connectorServices;
		}

		public ConnectorService connectorService(java.lang.String key) {
			return this.connectorServices.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of HTTPAcceptor resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPAcceptor> httpAcceptors() {
			return this.httpAcceptors;
		}

		public HTTPAcceptor httpAcceptor(java.lang.String key) {
			return this.httpAcceptors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ClusterConnection resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ClusterConnection> clusterConnections() {
			return this.clusterConnections;
		}

		public ClusterConnection clusterConnection(java.lang.String key) {
			return this.clusterConnections.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of BroadcastGroup resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<BroadcastGroup> broadcastGroups() {
			return this.broadcastGroups;
		}

		public BroadcastGroup broadcastGroup(java.lang.String key) {
			return this.broadcastGroups.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RuntimeQueue resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RuntimeQueue> runtimeQueues() {
			return this.runtimeQueues;
		}

		public RuntimeQueue runtimeQueue(java.lang.String key) {
			return this.runtimeQueues.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of AddressSetting resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AddressSetting> addressSettings() {
			return this.addressSettings;
		}

		public AddressSetting addressSetting(java.lang.String key) {
			return this.addressSettings.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of JMSQueue resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<JMSQueue> jmsQueues() {
			return this.jmsQueues;
		}

		public JMSQueue jmsQueue(java.lang.String key) {
			return this.jmsQueues.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of PooledConnectionFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<PooledConnectionFactory> pooledConnectionFactories() {
			return this.pooledConnectionFactories;
		}

		public PooledConnectionFactory pooledConnectionFactory(
				java.lang.String key) {
			return this.pooledConnectionFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Divert resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Divert> diverts() {
			return this.diverts;
		}

		public Divert divert(java.lang.String key) {
			return this.diverts.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of InVMAcceptor resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<InVMAcceptor> inVmAcceptors() {
			return this.inVmAcceptors;
		}

		public InVMAcceptor inVmAcceptor(java.lang.String key) {
			return this.inVmAcceptors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of DiscoveryGroup resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<DiscoveryGroup> discoveryGroups() {
			return this.discoveryGroups;
		}

		public DiscoveryGroup discoveryGroup(java.lang.String key) {
			return this.discoveryGroups.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of HTTPConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPConnector> httpConnectors() {
			return this.httpConnectors;
		}

		public HTTPConnector httpConnector(java.lang.String key) {
			return this.httpConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConnectionFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionFactory> connectionFactories() {
			return this.connectionFactories;
		}

		public ConnectionFactory connectionFactory(java.lang.String key) {
			return this.connectionFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Acceptor resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Acceptor> acceptors() {
			return this.acceptors;
		}

		public Acceptor acceptor(java.lang.String key) {
			return this.acceptors.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of RemoteAcceptor resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteAcceptor> remoteAcceptors() {
			return this.remoteAcceptors;
		}

		public RemoteAcceptor remoteAcceptor(java.lang.String key) {
			return this.remoteAcceptors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RemoteConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteConnector> remoteConnectors() {
			return this.remoteConnectors;
		}

		public RemoteConnector remoteConnector(java.lang.String key) {
			return this.remoteConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of InVMConnector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<InVMConnector> inVmConnectors() {
			return this.inVmConnectors;
		}

		public InVMConnector inVmConnector(java.lang.String key) {
			return this.inVmConnectors.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LegacyConnectionFactory resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LegacyConnectionFactory> legacyConnectionFactories() {
			return this.legacyConnectionFactories;
		}

		public LegacyConnectionFactory legacyConnectionFactory(
				java.lang.String key) {
			return this.legacyConnectionFactories.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of GroupingHandler resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<GroupingHandler> groupingHandlers() {
			return this.groupingHandlers;
		}

		public GroupingHandler groupingHandler(java.lang.String key) {
			return this.groupingHandlers.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of JMSTopic resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<JMSTopic> jmsTopics() {
			return this.jmsTopics;
		}

		public JMSTopic jmsTopic(java.lang.String key) {
			return this.jmsTopics.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of Connector resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		public Connector connector(java.lang.String key) {
			return this.connectors.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of SecuritySetting resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SecuritySetting> securitySettings() {
			return this.securitySettings;
		}

		public SecuritySetting securitySetting(java.lang.String key) {
			return this.securitySettings.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of CoreAddress resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CoreAddress> coreAddress() {
			return this.coreAddress;
		}

		public CoreAddress coreAddress(java.lang.String key) {
			return this.coreAddress.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Bridge resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Bridge> bridges() {
			return this.bridges;
		}

		public Bridge bridge(java.lang.String key) {
			return this.bridges.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of Queue resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Queue> queues() {
			return this.queues;
		}

		public Queue queue(java.lang.String key) {
			return this.queues.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public SharedStoreColocatedHAPolicy sharedStoreColocatedHaPolicy() {
			return this.sharedStoreColocatedHaPolicy;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public ReplicationMasterHAPolicy replicationMasterHaPolicy() {
			return this.replicationMasterHaPolicy;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public SharedStoreMasterHAPolicy sharedStoreMasterHaPolicy() {
			return this.sharedStoreMasterHaPolicy;
		}

		/**
		 * A filesystem path pointing to one of the locations where ActiveMQ
		 * stores persistent data.
		 */
		@Subresource
		public BindingsDirectoryPath bindingsDirectoryPath() {
			return this.bindingsDirectoryPath;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public ReplicationColocatedHAPolicy replicationColocatedHaPolicy() {
			return this.replicationColocatedHaPolicy;
		}

		/**
		 * A filesystem path pointing to one of the locations where ActiveMQ
		 * stores persistent data.
		 */
		@Subresource
		public JournalDirectoryPath journalDirectoryPath() {
			return this.journalDirectoryPath;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public SharedStoreSlaveHAPolicy sharedStoreSlaveHaPolicy() {
			return this.sharedStoreSlaveHaPolicy;
		}

		/**
		 * A filesystem path pointing to one of the locations where ActiveMQ
		 * stores persistent data.
		 */
		@Subresource
		public PagingDirectoryPath pagingDirectoryPath() {
			return this.pagingDirectoryPath;
		}

		/**
		 * A filesystem path pointing to one of the locations where ActiveMQ
		 * stores persistent data.
		 */
		@Subresource
		public LargeMessagesDirectoryPath largeMessagesDirectoryPath() {
			return this.largeMessagesDirectoryPath;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public LiveOnlyHAPolicy liveOnlyHaPolicy() {
			return this.liveOnlyHaPolicy;
		}

		/**
		 * A messaging resource that allows you to configure High Availability
		 * for the ActiveMQ server (the value of ha-policy can be live-only,
		 * replication-master, replication-slave, or replication-colocated).
		 */
		@Subresource
		public ReplicationSlaveHAPolicy replicationSlaveHaPolicy() {
			return this.replicationSlaveHaPolicy;
		}
	}

	public static enum JournalType {
		NIO("NIO"), ASYNCIO("ASYNCIO");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		JournalType(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in
	 * backup mode, waiting for failover).
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in
	 * backup mode, waiting for failover).
	 */
	@SuppressWarnings("unchecked")
	public T active(java.lang.Boolean value) {
		Object oldValue = this.active;
		this.active = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("active", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread
	 * from the thread pool for processing. False if they should be handled on
	 * the remoting thread.
	 */
	@ModelNodeBinding(detypedName = "async-connection-execution-enabled")
	public Boolean asyncConnectionExecutionEnabled() {
		return this.asyncConnectionExecutionEnabled;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread
	 * from the thread pool for processing. False if they should be handled on
	 * the remoting thread.
	 */
	@SuppressWarnings("unchecked")
	public T asyncConnectionExecutionEnabled(java.lang.Boolean value) {
		Object oldValue = this.asyncConnectionExecutionEnabled;
		this.asyncConnectionExecutionEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("asyncConnectionExecutionEnabled",
					oldValue, value);
		return (T) this;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive
	 * without receiving a ping.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl-override")
	public Long connectionTtlOverride() {
		return this.connectionTtlOverride;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive
	 * without receiving a ping.
	 */
	@SuppressWarnings("unchecked")
	public T connectionTtlOverride(java.lang.Long value) {
		Object oldValue = this.connectionTtlOverride;
		this.connectionTtlOverride = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionTtlOverride", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@ModelNodeBinding(detypedName = "id-cache-size")
	public Integer idCacheSize() {
		return this.idCacheSize;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@SuppressWarnings("unchecked")
	public T idCacheSize(java.lang.Integer value) {
		Object oldValue = this.idCacheSize;
		this.idCacheSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idCacheSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "incoming-interceptors")
	public List<Map> incomingInterceptors() {
		return this.incomingInterceptors;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T incomingInterceptors(java.util.List<java.util.Map> value) {
		Object oldValue = this.incomingInterceptors;
		this.incomingInterceptors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("incomingInterceptors", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T incomingInterceptor(java.util.Map value) {
		if (this.incomingInterceptors == null) {
			this.incomingInterceptors = new java.util.ArrayList<>();
		}
		this.incomingInterceptors.add(value);
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T incomingInterceptors(java.util.Map... args) {
		incomingInterceptors(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "outgoing-interceptors")
	public List<Map> outgoingInterceptors() {
		return this.outgoingInterceptors;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T outgoingInterceptors(java.util.List<java.util.Map> value) {
		Object oldValue = this.outgoingInterceptors;
		this.outgoingInterceptors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("outgoingInterceptors", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T outgoingInterceptor(java.util.Map value) {
		if (this.outgoingInterceptors == null) {
			this.outgoingInterceptors = new java.util.ArrayList<>();
		}
		this.outgoingInterceptors.add(value);
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T outgoingInterceptors(java.util.Map... args) {
		outgoingInterceptors(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@ModelNodeBinding(detypedName = "page-max-concurrent-io")
	public Integer pageMaxConcurrentIo() {
		return this.pageMaxConcurrentIo;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@SuppressWarnings("unchecked")
	public T pageMaxConcurrentIo(java.lang.Integer value) {
		Object oldValue = this.pageMaxConcurrentIo;
		this.pageMaxConcurrentIo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("pageMaxConcurrentIo", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that
	 * this only happens after a message has been cancelled.
	 */
	@ModelNodeBinding(detypedName = "persist-delivery-count-before-delivery")
	public Boolean persistDeliveryCountBeforeDelivery() {
		return this.persistDeliveryCountBeforeDelivery;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that
	 * this only happens after a message has been cancelled.
	 */
	@SuppressWarnings("unchecked")
	public T persistDeliveryCountBeforeDelivery(java.lang.Boolean value) {
		Object oldValue = this.persistDeliveryCountBeforeDelivery;
		this.persistDeliveryCountBeforeDelivery = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("persistDeliveryCountBeforeDelivery",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@ModelNodeBinding(detypedName = "persist-id-cache")
	public Boolean persistIdCache() {
		return this.persistIdCache;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@SuppressWarnings("unchecked")
	public T persistIdCache(java.lang.Boolean value) {
		Object oldValue = this.persistIdCache;
		this.persistIdCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("persistIdCache", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@ModelNodeBinding(detypedName = "persistence-enabled")
	public Boolean persistenceEnabled() {
		return this.persistenceEnabled;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceEnabled(java.lang.Boolean value) {
		Object oldValue = this.persistenceEnabled;
		this.persistenceEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("persistenceEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledThreadPoolMaxSize(java.lang.Integer value) {
		Object oldValue = this.scheduledThreadPoolMaxSize;
		this.scheduledThreadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scheduledThreadPoolMaxSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Whether this server is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this server is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(java.lang.Boolean value) {
		Object oldValue = this.started;
		this.started = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("started", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolMaxSize(java.lang.Integer value) {
		Object oldValue = this.threadPoolMaxSize;
		this.threadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadPoolMaxSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The server's version.
	 */
	@ModelNodeBinding(detypedName = "version")
	public String version() {
		return this.version;
	}

	/**
	 * The server's version.
	 */
	@SuppressWarnings("unchecked")
	public T version(java.lang.String value) {
		Object oldValue = this.version;
		this.version = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("version", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@ModelNodeBinding(detypedName = "wild-card-routing-enabled")
	public Boolean wildCardRoutingEnabled() {
		return this.wildCardRoutingEnabled;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@SuppressWarnings("unchecked")
	public T wildCardRoutingEnabled(java.lang.Boolean value) {
		Object oldValue = this.wildCardRoutingEnabled;
		this.wildCardRoutingEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("wildCardRoutingEnabled", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate to cluster
	 */
	@ModelNodeBinding(detypedName = "cluster-credential-reference")
	public Map clusterCredentialReference() {
		return this.clusterCredentialReference;
	}

	/**
	 * Credential (from Credential Store) to authenticate to cluster
	 */
	@SuppressWarnings("unchecked")
	public T clusterCredentialReference(java.util.Map value) {
		Object oldValue = this.clusterCredentialReference;
		this.clusterCredentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clusterCredentialReference", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate to cluster
	 */
	@SuppressWarnings("unchecked")
	public T clusterCredentialReference(java.lang.String key,
			java.lang.Object value) {
		if (this.clusterCredentialReference == null) {
			this.clusterCredentialReference = new java.util.HashMap<>();
		}
		this.clusterCredentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The password used by cluster connections to communicate between the
	 * clustered nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-password")
	public String clusterPassword() {
		return this.clusterPassword;
	}

	/**
	 * The password used by cluster connections to communicate between the
	 * clustered nodes.
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassword(java.lang.String value) {
		Object oldValue = this.clusterPassword;
		this.clusterPassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clusterPassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered
	 * nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-user")
	public String clusterUser() {
		return this.clusterUser;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered
	 * nodes.
	 */
	@SuppressWarnings("unchecked")
	public T clusterUser(java.lang.String value) {
		Object oldValue = this.clusterUser;
		this.clusterUser = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clusterUser", oldValue, value);
		return (T) this;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@ModelNodeBinding(detypedName = "memory-measure-interval")
	public Long memoryMeasureInterval() {
		return this.memoryMeasureInterval;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@SuppressWarnings("unchecked")
	public T memoryMeasureInterval(java.lang.Long value) {
		Object oldValue = this.memoryMeasureInterval;
		this.memoryMeasureInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("memoryMeasureInterval", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@ModelNodeBinding(detypedName = "memory-warning-threshold")
	public Integer memoryWarningThreshold() {
		return this.memoryWarningThreshold;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@SuppressWarnings("unchecked")
	public T memoryWarningThreshold(java.lang.Integer value) {
		Object oldValue = this.memoryWarningThreshold;
		this.memoryWarningThreshold = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("memoryWarningThreshold", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Number of pages to add to check the journal performance (only meant to be
	 * used to test performance of pages).
	 */
	@ModelNodeBinding(detypedName = "perf-blast-pages")
	public Integer perfBlastPages() {
		return this.perfBlastPages;
	}

	/**
	 * Number of pages to add to check the journal performance (only meant to be
	 * used to test performance of pages).
	 */
	@SuppressWarnings("unchecked")
	public T perfBlastPages(java.lang.Integer value) {
		Object oldValue = this.perfBlastPages;
		this.perfBlastPages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("perfBlastPages", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can
	 * sync. Useful when determining performance issues.
	 */
	@ModelNodeBinding(detypedName = "run-sync-speed-test")
	public Boolean runSyncSpeedTest() {
		return this.runSyncSpeedTest;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can
	 * sync. Useful when determining performance issues.
	 */
	@SuppressWarnings("unchecked")
	public T runSyncSpeedTest(java.lang.Boolean value) {
		Object oldValue = this.runSyncSpeedTest;
		this.runSyncSpeedTest = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("runSyncSpeedTest", oldValue, value);
		return (T) this;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value
	 * less than 1 disables this feature.
	 */
	@ModelNodeBinding(detypedName = "server-dump-interval")
	public Long serverDumpInterval() {
		return this.serverDumpInterval;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value
	 * less than 1 disables this feature.
	 */
	@SuppressWarnings("unchecked")
	public T serverDumpInterval(java.lang.Long value) {
		Object oldValue = this.serverDumpInterval;
		this.serverDumpInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverDumpInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-bindings-dir")
	public Boolean createBindingsDir() {
		return this.createBindingsDir;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public T createBindingsDir(java.lang.Boolean value) {
		Object oldValue = this.createBindingsDir;
		this.createBindingsDir = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("createBindingsDir", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-journal-dir")
	public Boolean createJournalDir() {
		return this.createJournalDir;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public T createJournalDir(java.lang.Boolean value) {
		Object oldValue = this.createJournalDir;
		this.createJournalDir = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("createJournalDir", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the JDBC table to store the bindings.
	 */
	@ModelNodeBinding(detypedName = "journal-bindings-table")
	public String journalBindingsTable() {
		return this.journalBindingsTable;
	}

	/**
	 * Name of the JDBC table to store the bindings.
	 */
	@SuppressWarnings("unchecked")
	public T journalBindingsTable(java.lang.String value) {
		Object oldValue = this.journalBindingsTable;
		this.journalBindingsTable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalBindingsTable", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-size")
	public Long journalBufferSize() {
		return this.journalBufferSize;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalBufferSize(java.lang.Long value) {
		Object oldValue = this.journalBufferSize;
		this.journalBufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalBufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the
	 * journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-timeout")
	public Long journalBufferTimeout() {
		return this.journalBufferTimeout;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the
	 * journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalBufferTimeout(java.lang.Long value) {
		Object oldValue = this.journalBufferTimeout;
		this.journalBufferTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalBufferTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-min-files")
	public Integer journalCompactMinFiles() {
		return this.journalCompactMinFiles;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@SuppressWarnings("unchecked")
	public T journalCompactMinFiles(java.lang.Integer value) {
		Object oldValue = this.journalCompactMinFiles;
		this.journalCompactMinFiles = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalCompactMinFiles", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-percentage")
	public Integer journalCompactPercentage() {
		return this.journalCompactPercentage;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalCompactPercentage(java.lang.Integer value) {
		Object oldValue = this.journalCompactPercentage;
		this.journalCompactPercentage = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalCompactPercentage", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Type of the database (can be used to customize SQL statements). If this
	 * attribute is not specified, the type of the database will be determined
	 * based on the DataSource metadata.
	 */
	@ModelNodeBinding(detypedName = "journal-database")
	public String journalDatabase() {
		return this.journalDatabase;
	}

	/**
	 * Type of the database (can be used to customize SQL statements). If this
	 * attribute is not specified, the type of the database will be determined
	 * based on the DataSource metadata.
	 */
	@SuppressWarnings("unchecked")
	public T journalDatabase(java.lang.String value) {
		Object oldValue = this.journalDatabase;
		this.journalDatabase = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalDatabase", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the DataSource for the JDBC store.
	 */
	@ModelNodeBinding(detypedName = "journal-datasource")
	public String journalDatasource() {
		return this.journalDatasource;
	}

	/**
	 * Name of the DataSource for the JDBC store.
	 */
	@SuppressWarnings("unchecked")
	public T journalDatasource(java.lang.String value) {
		Object oldValue = this.journalDatasource;
		this.journalDatasource = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalDatasource", oldValue, value);
		return (T) this;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@ModelNodeBinding(detypedName = "journal-file-size")
	public Long journalFileSize() {
		return this.journalFileSize;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@SuppressWarnings("unchecked")
	public T journalFileSize(java.lang.Long value) {
		Object oldValue = this.journalFileSize;
		this.journalFileSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalFileSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout used by the JDBC connection to detect network issues.
	 */
	@ModelNodeBinding(detypedName = "journal-jdbc-network-timeout")
	public Integer journalJdbcNetworkTimeout() {
		return this.journalJdbcNetworkTimeout;
	}

	/**
	 * The timeout used by the JDBC connection to detect network issues.
	 */
	@SuppressWarnings("unchecked")
	public T journalJdbcNetworkTimeout(java.lang.Integer value) {
		Object oldValue = this.journalJdbcNetworkTimeout;
		this.journalJdbcNetworkTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalJdbcNetworkTimeout", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Name of the JDBC table to store the JMS bindings.
	 */
	@ModelNodeBinding(detypedName = "journal-jms-bindings-table")
	public String journalJmsBindingsTable() {
		return this.journalJmsBindingsTable;
	}

	/**
	 * Name of the JDBC table to store the JMS bindings.
	 */
	@SuppressWarnings("unchecked")
	public T journalJmsBindingsTable(java.lang.String value) {
		Object oldValue = this.journalJmsBindingsTable;
		this.journalJmsBindingsTable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalJmsBindingsTable", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Name of the JDBC table to store the large messages.
	 */
	@ModelNodeBinding(detypedName = "journal-large-messages-table")
	public String journalLargeMessagesTable() {
		return this.journalLargeMessagesTable;
	}

	/**
	 * Name of the JDBC table to store the large messages.
	 */
	@SuppressWarnings("unchecked")
	public T journalLargeMessagesTable(java.lang.String value) {
		Object oldValue = this.journalLargeMessagesTable;
		this.journalLargeMessagesTable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalLargeMessagesTable", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any
	 * one time.
	 */
	@ModelNodeBinding(detypedName = "journal-max-io")
	public Integer journalMaxIo() {
		return this.journalMaxIo;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any
	 * one time.
	 */
	@SuppressWarnings("unchecked")
	public T journalMaxIo(java.lang.Integer value) {
		Object oldValue = this.journalMaxIo;
		this.journalMaxIo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalMaxIo", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the JDBC table to store the messages.
	 */
	@ModelNodeBinding(detypedName = "journal-messages-table")
	public String journalMessagesTable() {
		return this.journalMessagesTable;
	}

	/**
	 * Name of the JDBC table to store the messages.
	 */
	@SuppressWarnings("unchecked")
	public T journalMessagesTable(java.lang.String value) {
		Object oldValue = this.journalMessagesTable;
		this.journalMessagesTable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalMessagesTable", oldValue, value);
		return (T) this;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@ModelNodeBinding(detypedName = "journal-min-files")
	public Integer journalMinFiles() {
		return this.journalMinFiles;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@SuppressWarnings("unchecked")
	public T journalMinFiles(java.lang.Integer value) {
		Object oldValue = this.journalMinFiles;
		this.journalMinFiles = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalMinFiles", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the JDBC table to store pages.
	 */
	@ModelNodeBinding(detypedName = "journal-page-store-table")
	public String journalPageStoreTable() {
		return this.journalPageStoreTable;
	}

	/**
	 * Name of the JDBC table to store pages.
	 */
	@SuppressWarnings("unchecked")
	public T journalPageStoreTable(java.lang.String value) {
		Object oldValue = this.journalPageStoreTable;
		this.journalPageStoreTable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalPageStoreTable", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of journal files that can be reused. ActiveMQ will create as
	 * many files as needed however when reclaiming files it will shrink back to
	 * the value (-1 means no limit).
	 */
	@ModelNodeBinding(detypedName = "journal-pool-files")
	public Integer journalPoolFiles() {
		return this.journalPoolFiles;
	}

	/**
	 * The number of journal files that can be reused. ActiveMQ will create as
	 * many files as needed however when reclaiming files it will shrink back to
	 * the value (-1 means no limit).
	 */
	@SuppressWarnings("unchecked")
	public T journalPoolFiles(java.lang.Integer value) {
		Object oldValue = this.journalPoolFiles;
		this.journalPoolFiles = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalPoolFiles", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal
	 * before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-non-transactional")
	public Boolean journalSyncNonTransactional() {
		return this.journalSyncNonTransactional;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal
	 * before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public T journalSyncNonTransactional(java.lang.Boolean value) {
		Object oldValue = this.journalSyncNonTransactional;
		this.journalSyncNonTransactional = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalSyncNonTransactional",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal
	 * before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-transactional")
	public Boolean journalSyncTransactional() {
		return this.journalSyncTransactional;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal
	 * before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public T journalSyncTransactional(java.lang.Boolean value) {
		Object oldValue = this.journalSyncTransactional;
		this.journalSyncTransactional = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalSyncTransactional", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The type of journal to use.
	 */
	@ModelNodeBinding(detypedName = "journal-type")
	public JournalType journalType() {
		return this.journalType;
	}

	/**
	 * The type of journal to use.
	 */
	@SuppressWarnings("unchecked")
	public T journalType(JournalType value) {
		Object oldValue = this.journalType;
		this.journalType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalType", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@ModelNodeBinding(detypedName = "log-journal-write-rate")
	public Boolean logJournalWriteRate() {
		return this.logJournalWriteRate;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@SuppressWarnings("unchecked")
	public T logJournalWriteRate(java.lang.Boolean value) {
		Object oldValue = this.logJournalWriteRate;
		this.logJournalWriteRate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("logJournalWriteRate", oldValue, value);
		return (T) this;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the
	 * MBeanServer.
	 */
	@ModelNodeBinding(detypedName = "jmx-domain")
	public String jmxDomain() {
		return this.jmxDomain;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the
	 * MBeanServer.
	 */
	@SuppressWarnings("unchecked")
	public T jmxDomain(java.lang.String value) {
		Object oldValue = this.jmxDomain;
		this.jmxDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jmxDomain", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This
	 * is not recommended, as accessing these MBeans can lead to inconsistent
	 * configuration.
	 */
	@ModelNodeBinding(detypedName = "jmx-management-enabled")
	public Boolean jmxManagementEnabled() {
		return this.jmxManagementEnabled;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This
	 * is not recommended, as accessing these MBeans can lead to inconsistent
	 * configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jmxManagementEnabled(java.lang.Boolean value) {
		Object oldValue = this.jmxManagementEnabled;
		this.jmxManagementEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jmxManagementEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Address to send management messages to.
	 */
	@ModelNodeBinding(detypedName = "management-address")
	public String managementAddress() {
		return this.managementAddress;
	}

	/**
	 * Address to send management messages to.
	 */
	@SuppressWarnings("unchecked")
	public T managementAddress(java.lang.String value) {
		Object oldValue = this.managementAddress;
		this.managementAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managementAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the address that consumers bind to to receive management
	 * notifications.
	 */
	@ModelNodeBinding(detypedName = "management-notification-address")
	public String managementNotificationAddress() {
		return this.managementNotificationAddress;
	}

	/**
	 * The name of the address that consumers bind to to receive management
	 * notifications.
	 */
	@SuppressWarnings("unchecked")
	public T managementNotificationAddress(java.lang.String value) {
		Object oldValue = this.managementNotificationAddress;
		this.managementNotificationAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managementNotificationAddress",
					oldValue, value);
		return (T) this;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-scan-period")
	public Long messageExpiryScanPeriod() {
		return this.messageExpiryScanPeriod;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@SuppressWarnings("unchecked")
	public T messageExpiryScanPeriod(java.lang.Long value) {
		Object oldValue = this.messageExpiryScanPeriod;
		this.messageExpiryScanPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageExpiryScanPeriod", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-thread-priority")
	public Integer messageExpiryThreadPriority() {
		return this.messageExpiryThreadPriority;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@SuppressWarnings("unchecked")
	public T messageExpiryThreadPriority(java.lang.Integer value) {
		Object oldValue = this.messageExpiryThreadPriority;
		this.messageExpiryThreadPriority = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageExpiryThreadPriority",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the Elytron security domain used to verify user and role
	 * information.
	 */
	@ModelNodeBinding(detypedName = "elytron-domain")
	public String elytronDomain() {
		return this.elytronDomain;
	}

	/**
	 * The name of the Elytron security domain used to verify user and role
	 * information.
	 */
	@SuppressWarnings("unchecked")
	public T elytronDomain(java.lang.String value) {
		Object oldValue = this.elytronDomain;
		this.elytronDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("elytronDomain", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm
	 * connections.
	 */
	@ModelNodeBinding(detypedName = "override-in-vm-security")
	public Boolean overrideInVmSecurity() {
		return this.overrideInVmSecurity;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm
	 * connections.
	 */
	@SuppressWarnings("unchecked")
	public T overrideInVmSecurity(java.lang.Boolean value) {
		Object oldValue = this.overrideInVmSecurity;
		this.overrideInVmSecurity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("overrideInVmSecurity", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether security is enabled.
	 */
	@ModelNodeBinding(detypedName = "security-enabled")
	public Boolean securityEnabled() {
		return this.securityEnabled;
	}

	/**
	 * Whether security is enabled.
	 */
	@SuppressWarnings("unchecked")
	public T securityEnabled(java.lang.Boolean value) {
		Object oldValue = this.securityEnabled;
		this.securityEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@ModelNodeBinding(detypedName = "security-invalidation-interval")
	public Long securityInvalidationInterval() {
		return this.securityInvalidationInterval;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@SuppressWarnings("unchecked")
	public T securityInvalidationInterval(java.lang.Long value) {
		Object oldValue = this.securityInvalidationInterval;
		this.securityInvalidationInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityInvalidationInterval",
					oldValue, value);
		return (T) this;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@ModelNodeBinding(detypedName = "message-counter-max-day-history")
	public Integer messageCounterMaxDayHistory() {
		return this.messageCounterMaxDayHistory;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterMaxDayHistory(java.lang.Integer value) {
		Object oldValue = this.messageCounterMaxDayHistory;
		this.messageCounterMaxDayHistory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageCounterMaxDayHistory",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@ModelNodeBinding(detypedName = "message-counter-sample-period")
	public Long messageCounterSamplePeriod() {
		return this.messageCounterSamplePeriod;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterSamplePeriod(java.lang.Long value) {
		Object oldValue = this.messageCounterSamplePeriod;
		this.messageCounterSamplePeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageCounterSamplePeriod", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource
	 * manager after create time.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout")
	public Long transactionTimeout() {
		return this.transactionTimeout;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource
	 * manager after create time.
	 */
	@SuppressWarnings("unchecked")
	public T transactionTimeout(java.lang.Long value) {
		Object oldValue = this.transactionTimeout;
		this.transactionTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transactionTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout-scan-period")
	public Long transactionTimeoutScanPeriod() {
		return this.transactionTimeoutScanPeriod;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@SuppressWarnings("unchecked")
	public T transactionTimeoutScanPeriod(java.lang.Long value) {
		Object oldValue = this.transactionTimeoutScanPeriod;
		this.transactionTimeoutScanPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transactionTimeoutScanPeriod",
					oldValue, value);
		return (T) this;
	}
}