package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.Acceptor;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AcceptorConsumer<T extends Acceptor<T>> {

	/**
	 * Configure a pre-constructed instance of Acceptor resource
	 * 
	 * @parameter Instance of Acceptor to configure
	 * @return nothing
	 */
	void accept(T value);

	default AcceptorConsumer<T> andThen(AcceptorConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}