package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Used by a remote client to define how it connects to a server over HTTP.
 */
@Address("/subsystem=messaging-activemq/server=*/http-connector=*")
@ResourceType("http-connector")
public class HTTPConnector<T extends HTTPConnector<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The http-acceptor that serves as the endpoint of this http-connector.")
	private String endpoint;
	@AttributeDocumentation("A key-value pair understood by the connector factory-class and used to configure it.")
	private Map params;
	@AttributeDocumentation("The name of the ActiveMQ Artemis server that will be connected to on the remote server. If undefined, the name of the parent ActiveMQ Artemis server will be used (suitable if the http-connector is used to connect to the parent server)")
	private String serverName;
	@AttributeDocumentation("The socket binding that the connector will use to create connections.")
	private String socketBinding;

	public HTTPConnector(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The http-acceptor that serves as the endpoint of this http-connector.
	 */
	@ModelNodeBinding(detypedName = "endpoint")
	public String endpoint() {
		return this.endpoint;
	}

	/**
	 * The http-acceptor that serves as the endpoint of this http-connector.
	 */
	@SuppressWarnings("unchecked")
	public T endpoint(java.lang.String value) {
		Object oldValue = this.endpoint;
		this.endpoint = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("endpoint", oldValue, value);
		return (T) this;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(java.util.Map value) {
		Object oldValue = this.params;
		this.params = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("params", oldValue, value);
		return (T) this;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	@SuppressWarnings("unchecked")
	public T param(java.lang.String key, java.lang.Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}

	/**
	 * The name of the ActiveMQ Artemis server that will be connected to on the
	 * remote server. If undefined, the name of the parent ActiveMQ Artemis
	 * server will be used (suitable if the http-connector is used to connect to
	 * the parent server)
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The name of the ActiveMQ Artemis server that will be connected to on the
	 * remote server. If undefined, the name of the parent ActiveMQ Artemis
	 * server will be used (suitable if the http-connector is used to connect to
	 * the parent server)
	 */
	@SuppressWarnings("unchecked")
	public T serverName(java.lang.String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}
}