package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.messaging.activemq.FactoryType;
import java.math.BigDecimal;

/**
 * Defines a connection factory.
 */
@Address("/subsystem=messaging-activemq/server=*/legacy-connection-factory=*")
@ResourceType("legacy-connection-factory")
public class LegacyConnectionFactory<T extends LegacyConnectionFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Whether or not message grouping is automatically used")
	private Boolean autoGroup;
	@AttributeDocumentation("True to set block on acknowledge.")
	private Boolean blockOnAcknowledge;
	@AttributeDocumentation("True to set block on durable send.")
	private Boolean blockOnDurableSend;
	@AttributeDocumentation("True to set block on non durable send.")
	private Boolean blockOnNonDurableSend;
	@AttributeDocumentation("True to cache large messages.")
	private Boolean cacheLargeMessageClient;
	@AttributeDocumentation("The timeout to use when fail over is in process (in ms).")
	private Long callFailoverTimeout;
	@AttributeDocumentation("The call time out.")
	private Long callTimeout;
	@AttributeDocumentation("The client failure check period.")
	private Long clientFailureCheckPeriod;
	@AttributeDocumentation("The client id.")
	private String clientId;
	@AttributeDocumentation("Whether large messages should be compressed.")
	private Boolean compressLargeMessages;
	@AttributeDocumentation("The confirmation window size.")
	private Integer confirmationWindowSize;
	@AttributeDocumentation("Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.")
	private String connectionLoadBalancingPolicyClassName;
	@AttributeDocumentation("The connection ttl.")
	private Long connectionTtl;
	@AttributeDocumentation("Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.")
	private List<String> connectors;
	@AttributeDocumentation("The consumer max rate.")
	private Integer consumerMaxRate;
	@AttributeDocumentation("The consumer window size.")
	private Integer consumerWindowSize;
	@AttributeDocumentation("The discovery group name.")
	private String discoveryGroup;
	@AttributeDocumentation("The dups ok batch size.")
	private Integer dupsOkBatchSize;
	@AttributeDocumentation("The jndi names the connection factory should be bound to.")
	private List<String> entries;
	@AttributeDocumentation("The type of connection factory.")
	private FactoryType factoryType;
	@AttributeDocumentation("True to fail over on initial connection.")
	private Boolean failoverOnInitialConnection;
	@AttributeDocumentation("The group id.")
	private String groupId;
	@AttributeDocumentation("Whether the connection factory supports High Availability.")
	private Boolean ha;
	@AttributeDocumentation("The number of attempts for the initial connection to the server.")
	private Integer initialConnectAttempts;
	@AttributeDocumentation("The initial size of messages created through this factory.")
	private Integer initialMessagePacketSize;
	@AttributeDocumentation("The max retry interval.")
	private Long maxRetryInterval;
	@AttributeDocumentation("The min large message size.")
	private Integer minLargeMessageSize;
	@AttributeDocumentation("True to pre-acknowledge.")
	private Boolean preAcknowledge;
	@AttributeDocumentation("The producer max rate.")
	private Integer producerMaxRate;
	@AttributeDocumentation("The producer window size.")
	private Integer producerWindowSize;
	@AttributeDocumentation("The reconnect attempts.")
	private Integer reconnectAttempts;
	@AttributeDocumentation("The retry interval.")
	private Long retryInterval;
	@AttributeDocumentation("The retry interval multiplier.")
	private BigDecimal retryIntervalMultiplier;
	@AttributeDocumentation("The scheduled thread pool max size.")
	private Integer scheduledThreadPoolMaxSize;
	@AttributeDocumentation("The thread pool max size.")
	private Integer threadPoolMaxSize;
	@AttributeDocumentation("The transaction batch size.")
	private Integer transactionBatchSize;
	@AttributeDocumentation("True to use global pools.")
	private Boolean useGlobalPools;

	public LegacyConnectionFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Whether or not message grouping is automatically used
	 */
	@ModelNodeBinding(detypedName = "auto-group")
	public Boolean autoGroup() {
		return this.autoGroup;
	}

	/**
	 * Whether or not message grouping is automatically used
	 */
	@SuppressWarnings("unchecked")
	public T autoGroup(java.lang.Boolean value) {
		Object oldValue = this.autoGroup;
		this.autoGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@ModelNodeBinding(detypedName = "block-on-acknowledge")
	public Boolean blockOnAcknowledge() {
		return this.blockOnAcknowledge;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public T blockOnAcknowledge(java.lang.Boolean value) {
		Object oldValue = this.blockOnAcknowledge;
		this.blockOnAcknowledge = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("blockOnAcknowledge", oldValue, value);
		return (T) this;
	}

	/**
	 * True to set block on durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-durable-send")
	public Boolean blockOnDurableSend() {
		return this.blockOnDurableSend;
	}

	/**
	 * True to set block on durable send.
	 */
	@SuppressWarnings("unchecked")
	public T blockOnDurableSend(java.lang.Boolean value) {
		Object oldValue = this.blockOnDurableSend;
		this.blockOnDurableSend = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("blockOnDurableSend", oldValue, value);
		return (T) this;
	}

	/**
	 * True to set block on non durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-non-durable-send")
	public Boolean blockOnNonDurableSend() {
		return this.blockOnNonDurableSend;
	}

	/**
	 * True to set block on non durable send.
	 */
	@SuppressWarnings("unchecked")
	public T blockOnNonDurableSend(java.lang.Boolean value) {
		Object oldValue = this.blockOnNonDurableSend;
		this.blockOnNonDurableSend = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("blockOnNonDurableSend", oldValue,
					value);
		return (T) this;
	}

	/**
	 * True to cache large messages.
	 */
	@ModelNodeBinding(detypedName = "cache-large-message-client")
	public Boolean cacheLargeMessageClient() {
		return this.cacheLargeMessageClient;
	}

	/**
	 * True to cache large messages.
	 */
	@SuppressWarnings("unchecked")
	public T cacheLargeMessageClient(java.lang.Boolean value) {
		Object oldValue = this.cacheLargeMessageClient;
		this.cacheLargeMessageClient = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheLargeMessageClient", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@ModelNodeBinding(detypedName = "call-failover-timeout")
	public Long callFailoverTimeout() {
		return this.callFailoverTimeout;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@SuppressWarnings("unchecked")
	public T callFailoverTimeout(java.lang.Long value) {
		Object oldValue = this.callFailoverTimeout;
		this.callFailoverTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("callFailoverTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The call time out.
	 */
	@ModelNodeBinding(detypedName = "call-timeout")
	public Long callTimeout() {
		return this.callTimeout;
	}

	/**
	 * The call time out.
	 */
	@SuppressWarnings("unchecked")
	public T callTimeout(java.lang.Long value) {
		Object oldValue = this.callTimeout;
		this.callTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("callTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The client failure check period.
	 */
	@ModelNodeBinding(detypedName = "client-failure-check-period")
	public Long clientFailureCheckPeriod() {
		return this.clientFailureCheckPeriod;
	}

	/**
	 * The client failure check period.
	 */
	@SuppressWarnings("unchecked")
	public T clientFailureCheckPeriod(java.lang.Long value) {
		Object oldValue = this.clientFailureCheckPeriod;
		this.clientFailureCheckPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientFailureCheckPeriod", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The client id.
	 */
	@ModelNodeBinding(detypedName = "client-id")
	public String clientId() {
		return this.clientId;
	}

	/**
	 * The client id.
	 */
	@SuppressWarnings("unchecked")
	public T clientId(java.lang.String value) {
		Object oldValue = this.clientId;
		this.clientId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientId", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@ModelNodeBinding(detypedName = "compress-large-messages")
	public Boolean compressLargeMessages() {
		return this.compressLargeMessages;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@SuppressWarnings("unchecked")
	public T compressLargeMessages(java.lang.Boolean value) {
		Object oldValue = this.compressLargeMessages;
		this.compressLargeMessages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("compressLargeMessages", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The confirmation window size.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation window size.
	 */
	@SuppressWarnings("unchecked")
	public T confirmationWindowSize(java.lang.Integer value) {
		Object oldValue = this.confirmationWindowSize;
		this.confirmationWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("confirmationWindowSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a
	 * client can use to load balance sessions across different nodes in a
	 * cluster.
	 */
	@ModelNodeBinding(detypedName = "connection-load-balancing-policy-class-name")
	public String connectionLoadBalancingPolicyClassName() {
		return this.connectionLoadBalancingPolicyClassName;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a
	 * client can use to load balance sessions across different nodes in a
	 * cluster.
	 */
	@SuppressWarnings("unchecked")
	public T connectionLoadBalancingPolicyClassName(java.lang.String value) {
		Object oldValue = this.connectionLoadBalancingPolicyClassName;
		this.connectionLoadBalancingPolicyClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange(
					"connectionLoadBalancingPolicyClassName", oldValue, value);
		return (T) this;
	}

	/**
	 * The connection ttl.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The connection ttl.
	 */
	@SuppressWarnings("unchecked")
	public T connectionTtl(java.lang.Long value) {
		Object oldValue = this.connectionTtl;
		this.connectionTtl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionTtl", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(java.util.List<String> value) {
		Object oldValue = this.connectors;
		this.connectors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectors", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connector(String value) {
		if (this.connectors == null) {
			this.connectors = new java.util.ArrayList<>();
		}
		this.connectors.add(value);
		return (T) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(String... args) {
		connectors(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The consumer max rate.
	 */
	@ModelNodeBinding(detypedName = "consumer-max-rate")
	public Integer consumerMaxRate() {
		return this.consumerMaxRate;
	}

	/**
	 * The consumer max rate.
	 */
	@SuppressWarnings("unchecked")
	public T consumerMaxRate(java.lang.Integer value) {
		Object oldValue = this.consumerMaxRate;
		this.consumerMaxRate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consumerMaxRate", oldValue, value);
		return (T) this;
	}

	/**
	 * The consumer window size.
	 */
	@ModelNodeBinding(detypedName = "consumer-window-size")
	public Integer consumerWindowSize() {
		return this.consumerWindowSize;
	}

	/**
	 * The consumer window size.
	 */
	@SuppressWarnings("unchecked")
	public T consumerWindowSize(java.lang.Integer value) {
		Object oldValue = this.consumerWindowSize;
		this.consumerWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consumerWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The discovery group name.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The discovery group name.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String value) {
		Object oldValue = this.discoveryGroup;
		this.discoveryGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("discoveryGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * The dups ok batch size.
	 */
	@ModelNodeBinding(detypedName = "dups-ok-batch-size")
	public Integer dupsOkBatchSize() {
		return this.dupsOkBatchSize;
	}

	/**
	 * The dups ok batch size.
	 */
	@SuppressWarnings("unchecked")
	public T dupsOkBatchSize(java.lang.Integer value) {
		Object oldValue = this.dupsOkBatchSize;
		this.dupsOkBatchSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dupsOkBatchSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(java.util.List<String> value) {
		Object oldValue = this.entries;
		this.entries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("entries", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entry(String value) {
		if (this.entries == null) {
			this.entries = new java.util.ArrayList<>();
		}
		this.entries.add(value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(String... args) {
		entries(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The type of connection factory.
	 */
	@ModelNodeBinding(detypedName = "factory-type")
	public FactoryType factoryType() {
		return this.factoryType;
	}

	/**
	 * The type of connection factory.
	 */
	@SuppressWarnings("unchecked")
	public T factoryType(FactoryType value) {
		Object oldValue = this.factoryType;
		this.factoryType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("factoryType", oldValue, value);
		return (T) this;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@ModelNodeBinding(detypedName = "failover-on-initial-connection")
	public Boolean failoverOnInitialConnection() {
		return this.failoverOnInitialConnection;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@SuppressWarnings("unchecked")
	public T failoverOnInitialConnection(java.lang.Boolean value) {
		Object oldValue = this.failoverOnInitialConnection;
		this.failoverOnInitialConnection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failoverOnInitialConnection",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The group id.
	 */
	@ModelNodeBinding(detypedName = "group-id")
	public String groupId() {
		return this.groupId;
	}

	/**
	 * The group id.
	 */
	@SuppressWarnings("unchecked")
	public T groupId(java.lang.String value) {
		Object oldValue = this.groupId;
		this.groupId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupId", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@ModelNodeBinding(detypedName = "ha")
	public Boolean ha() {
		return this.ha;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@SuppressWarnings("unchecked")
	public T ha(java.lang.Boolean value) {
		Object oldValue = this.ha;
		this.ha = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ha", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of attempts for the initial connection to the server.
	 */
	@ModelNodeBinding(detypedName = "initial-connect-attempts")
	public Integer initialConnectAttempts() {
		return this.initialConnectAttempts;
	}

	/**
	 * The number of attempts for the initial connection to the server.
	 */
	@SuppressWarnings("unchecked")
	public T initialConnectAttempts(java.lang.Integer value) {
		Object oldValue = this.initialConnectAttempts;
		this.initialConnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialConnectAttempts", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The initial size of messages created through this factory.
	 */
	@ModelNodeBinding(detypedName = "initial-message-packet-size")
	public Integer initialMessagePacketSize() {
		return this.initialMessagePacketSize;
	}

	/**
	 * The initial size of messages created through this factory.
	 */
	@SuppressWarnings("unchecked")
	public T initialMessagePacketSize(java.lang.Integer value) {
		Object oldValue = this.initialMessagePacketSize;
		this.initialMessagePacketSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialMessagePacketSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The max retry interval.
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The max retry interval.
	 */
	@SuppressWarnings("unchecked")
	public T maxRetryInterval(java.lang.Long value) {
		Object oldValue = this.maxRetryInterval;
		this.maxRetryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRetryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The min large message size.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The min large message size.
	 */
	@SuppressWarnings("unchecked")
	public T minLargeMessageSize(java.lang.Integer value) {
		Object oldValue = this.minLargeMessageSize;
		this.minLargeMessageSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minLargeMessageSize", oldValue, value);
		return (T) this;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@ModelNodeBinding(detypedName = "pre-acknowledge")
	public Boolean preAcknowledge() {
		return this.preAcknowledge;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public T preAcknowledge(java.lang.Boolean value) {
		Object oldValue = this.preAcknowledge;
		this.preAcknowledge = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("preAcknowledge", oldValue, value);
		return (T) this;
	}

	/**
	 * The producer max rate.
	 */
	@ModelNodeBinding(detypedName = "producer-max-rate")
	public Integer producerMaxRate() {
		return this.producerMaxRate;
	}

	/**
	 * The producer max rate.
	 */
	@SuppressWarnings("unchecked")
	public T producerMaxRate(java.lang.Integer value) {
		Object oldValue = this.producerMaxRate;
		this.producerMaxRate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("producerMaxRate", oldValue, value);
		return (T) this;
	}

	/**
	 * The producer window size.
	 */
	@ModelNodeBinding(detypedName = "producer-window-size")
	public Integer producerWindowSize() {
		return this.producerWindowSize;
	}

	/**
	 * The producer window size.
	 */
	@SuppressWarnings("unchecked")
	public T producerWindowSize(java.lang.Integer value) {
		Object oldValue = this.producerWindowSize;
		this.producerWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("producerWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The reconnect attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The reconnect attempts.
	 */
	@SuppressWarnings("unchecked")
	public T reconnectAttempts(java.lang.Integer value) {
		Object oldValue = this.reconnectAttempts;
		this.reconnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reconnectAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * The retry interval.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The retry interval.
	 */
	@SuppressWarnings("unchecked")
	public T retryInterval(java.lang.Long value) {
		Object oldValue = this.retryInterval;
		this.retryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("retryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The retry interval multiplier.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public BigDecimal retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * The retry interval multiplier.
	 */
	@SuppressWarnings("unchecked")
	public T retryIntervalMultiplier(java.math.BigDecimal value) {
		Object oldValue = this.retryIntervalMultiplier;
		this.retryIntervalMultiplier = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("retryIntervalMultiplier", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledThreadPoolMaxSize(java.lang.Integer value) {
		Object oldValue = this.scheduledThreadPoolMaxSize;
		this.scheduledThreadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scheduledThreadPoolMaxSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolMaxSize(java.lang.Integer value) {
		Object oldValue = this.threadPoolMaxSize;
		this.threadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadPoolMaxSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The transaction batch size.
	 */
	@ModelNodeBinding(detypedName = "transaction-batch-size")
	public Integer transactionBatchSize() {
		return this.transactionBatchSize;
	}

	/**
	 * The transaction batch size.
	 */
	@SuppressWarnings("unchecked")
	public T transactionBatchSize(java.lang.Integer value) {
		Object oldValue = this.transactionBatchSize;
		this.transactionBatchSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transactionBatchSize", oldValue, value);
		return (T) this;
	}

	/**
	 * True to use global pools.
	 */
	@ModelNodeBinding(detypedName = "use-global-pools")
	public Boolean useGlobalPools() {
		return this.useGlobalPools;
	}

	/**
	 * True to use global pools.
	 */
	@SuppressWarnings("unchecked")
	public T useGlobalPools(java.lang.Boolean value) {
		Object oldValue = this.useGlobalPools;
		this.useGlobalPools = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useGlobalPools", oldValue, value);
		return (T) this;
	}
}