package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.LiveOnlyHAPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LiveOnlyHAPolicyConsumer<T extends LiveOnlyHAPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of LiveOnlyHAPolicy resource
	 * 
	 * @parameter Instance of LiveOnlyHAPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default LiveOnlyHAPolicyConsumer<T> andThen(
			LiveOnlyHAPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}