package org.wildfly.swarm.config.modcluster.mod_cluster_config;

import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationDynamicLoadProvider;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConfigurationDynamicLoadProviderConsumer<T extends ConfigurationDynamicLoadProvider<T>> {

	/**
	 * Configure a pre-constructed instance of ConfigurationDynamicLoadProvider
	 * resource
	 * 
	 * @parameter Instance of ConfigurationDynamicLoadProvider to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigurationDynamicLoadProviderConsumer<T> andThen(
			ConfigurationDynamicLoadProviderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}