package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.security.ElytronKeyStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ElytronKeyStoreConsumer<T extends ElytronKeyStore<T>> {

	/**
	 * Configure a pre-constructed instance of ElytronKeyStore resource
	 * 
	 * @parameter Instance of ElytronKeyStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default ElytronKeyStoreConsumer<T> andThen(ElytronKeyStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}