package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModuleSupplier;
import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Identity trust configuration. Configures a list of trust modules to be used.
 */
@Address("/subsystem=security/security-domain=*/identity-trust=classic")
@ResourceType("identity-trust")
@Implicit
public class ClassicIdentityTrust<T extends ClassicIdentityTrust<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ClassicIdentityTrustResources subresources = new ClassicIdentityTrustResources();

	public ClassicIdentityTrust() {
		super();
		this.key = "classic";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ClassicIdentityTrustResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all TrustModule objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of TrustModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T trustModules(java.util.List<TrustModule> value) {
		this.subresources.trustModules = value;
		return (T) this;
	}

	/**
	 * Add the TrustModule object to the list of subresources
	 * 
	 * @param value
	 *            The TrustModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T trustModule(TrustModule value) {
		this.subresources.trustModules.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a TrustModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the TrustModule resource
	 * @param config
	 *            The TrustModuleConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T trustModule(java.lang.String childKey, TrustModuleConsumer consumer) {
		TrustModule<? extends TrustModule> child = new TrustModule<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		trustModule(child);
		return (T) this;
	}

	/**
	 * Create and configure a TrustModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the TrustModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T trustModule(java.lang.String childKey) {
		trustModule(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied TrustModule object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T trustModule(TrustModuleSupplier supplier) {
		trustModule(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ClassicIdentityTrust
	 */
	public static class ClassicIdentityTrustResources {
		/**
		 * List of authentication modules
		 */
		@ResourceDocumentation("List of authentication modules")
		@SubresourceInfo("trustModule")
		private List<TrustModule> trustModules = new java.util.ArrayList<>();

		/**
		 * Get the list of TrustModule resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<TrustModule> trustModules() {
			return this.trustModules;
		}

		public TrustModule trustModule(java.lang.String key) {
			return this.trustModules.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}