package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.undertow.ApplicationSecurityDomain;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ApplicationSecurityDomainConsumer<T extends ApplicationSecurityDomain<T>> {

	/**
	 * Configure a pre-constructed instance of ApplicationSecurityDomain
	 * resource
	 * 
	 * @parameter Instance of ApplicationSecurityDomain to configure
	 * @return nothing
	 */
	void accept(T value);

	default ApplicationSecurityDomainConsumer<T> andThen(
			ApplicationSecurityDomainConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}