package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The buffer cache used to cache static content
 */
@Address("/subsystem=undertow/buffer-cache=*")
@ResourceType("buffer-cache")
public class BufferCache<T extends BufferCache<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The size of an individual buffer, in bytes.")
	private Integer bufferSize;
	@AttributeDocumentation("The numbers of buffers in a region")
	private Integer buffersPerRegion;
	@AttributeDocumentation("The maximum number of regions")
	private Integer maxRegions;

	public BufferCache(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The size of an individual buffer, in bytes.
	 */
	@ModelNodeBinding(detypedName = "buffer-size")
	public Integer bufferSize() {
		return this.bufferSize;
	}

	/**
	 * The size of an individual buffer, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T bufferSize(java.lang.Integer value) {
		Object oldValue = this.bufferSize;
		this.bufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The numbers of buffers in a region
	 */
	@ModelNodeBinding(detypedName = "buffers-per-region")
	public Integer buffersPerRegion() {
		return this.buffersPerRegion;
	}

	/**
	 * The numbers of buffers in a region
	 */
	@SuppressWarnings("unchecked")
	public T buffersPerRegion(java.lang.Integer value) {
		Object oldValue = this.buffersPerRegion;
		this.buffersPerRegion = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("buffersPerRegion", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of regions
	 */
	@ModelNodeBinding(detypedName = "max-regions")
	public Integer maxRegions() {
		return this.maxRegions;
	}

	/**
	 * The maximum number of regions
	 */
	@SuppressWarnings("unchecked")
	public T maxRegions(java.lang.Integer value) {
		Object oldValue = this.maxRegions;
		this.maxRegions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRegions", oldValue, value);
		return (T) this;
	}
}