package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.CustomFilter;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomFilterConsumer<T extends CustomFilter<T>> {

	/**
	 * Configure a pre-constructed instance of CustomFilter resource
	 * 
	 * @parameter Instance of CustomFilter to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomFilterConsumer<T> andThen(CustomFilterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}