package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Response header filter allows you to add custom headers.
 */
@Address("/subsystem=undertow/configuration=filter/response-header=*")
@ResourceType("response-header")
public class ResponseHeader<T extends ResponseHeader<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Header name")
	private String headerName;
	@AttributeDocumentation("Value for header")
	private String headerValue;

	public ResponseHeader(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Header name
	 */
	@ModelNodeBinding(detypedName = "header-name")
	public String headerName() {
		return this.headerName;
	}

	/**
	 * Header name
	 */
	@SuppressWarnings("unchecked")
	public T headerName(java.lang.String value) {
		Object oldValue = this.headerName;
		this.headerName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("headerName", oldValue, value);
		return (T) this;
	}

	/**
	 * Value for header
	 */
	@ModelNodeBinding(detypedName = "header-value")
	public String headerValue() {
		return this.headerValue;
	}

	/**
	 * Value for header
	 */
	@SuppressWarnings("unchecked")
	public T headerValue(java.lang.String value) {
		Object oldValue = this.headerValue;
		this.headerValue = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("headerValue", oldValue, value);
		return (T) this;
	}
}