/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptions;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptionsConsumer;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptionsSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=ejb3/service=remote")
@ResourceType(value="service")
@Implicit
public class RemoteService<T extends RemoteService<T>>
implements Keyed {
    private String key = "remote";
    private PropertyChangeSupport pcs;
    private RemoteServiceResources subresources = new RemoteServiceResources();
    @AttributeDocumentation(value="The name of the clustered cache container which will be used to store/access the client-mappings of the EJB remoting connector's socket-binding on each node, in the cluster")
    private String cluster;
    @AttributeDocumentation(value="The name of the connector on which the EJB3 remoting channel is registered")
    private String connectorRef;
    @AttributeDocumentation(value="If this is true the EJB request will be executed in the IO subsystems worker, otherwise it will dispatch to the EJB thread pool")
    private Boolean executeInWorker;
    @AttributeDocumentation(value="The name of the thread pool that handles remote invocations")
    private String threadPoolName;

    public RemoteService() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public RemoteServiceResources subresources() {
        return this.subresources;
    }

    public T channelCreationOptions(List<ChannelCreationOptions> value) {
        this.subresources.channelCreationOptions = value;
        return (T)this;
    }

    public T channelCreationOptions(ChannelCreationOptions value) {
        this.subresources.channelCreationOptions.add(value);
        return (T)this;
    }

    public T channelCreationOptions(String childKey, ChannelCreationOptionsConsumer consumer) {
        ChannelCreationOptions child = new ChannelCreationOptions(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.channelCreationOptions(child);
        return (T)this;
    }

    public T channelCreationOptions(String childKey) {
        this.channelCreationOptions(childKey, null);
        return (T)this;
    }

    public T channelCreationOptions(ChannelCreationOptionsSupplier supplier) {
        this.channelCreationOptions(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cluster")
    public String cluster() {
        return this.cluster;
    }

    public T cluster(String value) {
        String oldValue = this.cluster;
        this.cluster = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cluster", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connector-ref")
    public String connectorRef() {
        return this.connectorRef;
    }

    public T connectorRef(String value) {
        String oldValue = this.connectorRef;
        this.connectorRef = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectorRef", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="execute-in-worker")
    public Boolean executeInWorker() {
        return this.executeInWorker;
    }

    public T executeInWorker(Boolean value) {
        Boolean oldValue = this.executeInWorker;
        this.executeInWorker = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("executeInWorker", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-pool-name")
    public String threadPoolName() {
        return this.threadPoolName;
    }

    public T threadPoolName(String value) {
        String oldValue = this.threadPoolName;
        this.threadPoolName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadPoolName", oldValue, value);
        }
        return (T)this;
    }

    public static class RemoteServiceResources {
        @ResourceDocumentation(value="The options that will be used during the EJB remote channel creation")
        @SubresourceInfo(value="channelCreationOptions")
        private List<ChannelCreationOptions> channelCreationOptions = new ArrayList<ChannelCreationOptions>();

        @Subresource
        public List<ChannelCreationOptions> channelCreationOptions() {
            return this.channelCreationOptions;
        }

        public ChannelCreationOptions channelCreationOptions(String key) {
            return this.channelCreationOptions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

