/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/security-domain=*")
@ResourceType(value="security-domain")
public class SecurityDomain<T extends SecurityDomain<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The default realm contained by this security domain.")
    private String defaultRealm;
    @AttributeDocumentation(value="When outflowing to a security domain if outflow is not possible should the anonymous identity be used?  Outflowing anonymous has the effect of clearing any identity already established for that domain.")
    private Boolean outflowAnonymous;
    @AttributeDocumentation(value="The list of security domains that the security identity from this domain should automatically outflow to.")
    private List<String> outflowSecurityDomains;
    @AttributeDocumentation(value="A reference to a PermissionMapper to be used by this domain.")
    private String permissionMapper;
    @AttributeDocumentation(value="A reference to a principal transformer to be applied after the realm has operated on the supplied identity name.")
    private String postRealmPrincipalTransformer;
    @AttributeDocumentation(value="A reference to a principal transformer to be applied before the realm is selected.")
    private String preRealmPrincipalTransformer;
    @AttributeDocumentation(value="A reference to a PrincipalDecoder to be used by this domain.")
    private String principalDecoder;
    @AttributeDocumentation(value="Reference to the RealmMapper to be used by this domain.")
    private String realmMapper;
    @AttributeDocumentation(value="The list of realms contained by this security domain.")
    private List<Map> realms;
    @AttributeDocumentation(value="Reference to the RoleMapper to be used by this domain.")
    private String roleMapper;
    @AttributeDocumentation(value="Reference to a listener for security events.")
    private String securityEventListener;
    @AttributeDocumentation(value="The list of security domains that are trusted by this security domain.")
    private List<String> trustedSecurityDomains;

    public SecurityDomain(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="default-realm")
    public String defaultRealm() {
        return this.defaultRealm;
    }

    public T defaultRealm(String value) {
        String oldValue = this.defaultRealm;
        this.defaultRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="outflow-anonymous")
    public Boolean outflowAnonymous() {
        return this.outflowAnonymous;
    }

    public T outflowAnonymous(Boolean value) {
        Boolean oldValue = this.outflowAnonymous;
        this.outflowAnonymous = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outflowAnonymous", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="outflow-security-domains")
    public List<String> outflowSecurityDomains() {
        return this.outflowSecurityDomains;
    }

    public T outflowSecurityDomains(List<String> value) {
        List<String> oldValue = this.outflowSecurityDomains;
        this.outflowSecurityDomains = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outflowSecurityDomains", oldValue, value);
        }
        return (T)this;
    }

    public T outflowSecurityDomain(String value) {
        if (this.outflowSecurityDomains == null) {
            this.outflowSecurityDomains = new ArrayList<String>();
        }
        this.outflowSecurityDomains.add(value);
        return (T)this;
    }

    public T outflowSecurityDomains(String ... args) {
        this.outflowSecurityDomains(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="permission-mapper")
    public String permissionMapper() {
        return this.permissionMapper;
    }

    public T permissionMapper(String value) {
        String oldValue = this.permissionMapper;
        this.permissionMapper = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("permissionMapper", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="post-realm-principal-transformer")
    public String postRealmPrincipalTransformer() {
        return this.postRealmPrincipalTransformer;
    }

    public T postRealmPrincipalTransformer(String value) {
        String oldValue = this.postRealmPrincipalTransformer;
        this.postRealmPrincipalTransformer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("postRealmPrincipalTransformer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pre-realm-principal-transformer")
    public String preRealmPrincipalTransformer() {
        return this.preRealmPrincipalTransformer;
    }

    public T preRealmPrincipalTransformer(String value) {
        String oldValue = this.preRealmPrincipalTransformer;
        this.preRealmPrincipalTransformer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preRealmPrincipalTransformer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="principal-decoder")
    public String principalDecoder() {
        return this.principalDecoder;
    }

    public T principalDecoder(String value) {
        String oldValue = this.principalDecoder;
        this.principalDecoder = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("principalDecoder", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm-mapper")
    public String realmMapper() {
        return this.realmMapper;
    }

    public T realmMapper(String value) {
        String oldValue = this.realmMapper;
        this.realmMapper = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realmMapper", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realms")
    public List<Map> realms() {
        return this.realms;
    }

    public T realms(List<Map> value) {
        List<Map> oldValue = this.realms;
        this.realms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realms", oldValue, value);
        }
        return (T)this;
    }

    public T realm(Map value) {
        if (this.realms == null) {
            this.realms = new ArrayList<Map>();
        }
        this.realms.add(value);
        return (T)this;
    }

    public T realms(Map ... args) {
        this.realms(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="role-mapper")
    public String roleMapper() {
        return this.roleMapper;
    }

    public T roleMapper(String value) {
        String oldValue = this.roleMapper;
        this.roleMapper = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("roleMapper", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-event-listener")
    public String securityEventListener() {
        return this.securityEventListener;
    }

    public T securityEventListener(String value) {
        String oldValue = this.securityEventListener;
        this.securityEventListener = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityEventListener", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="trusted-security-domains")
    public List<String> trustedSecurityDomains() {
        return this.trustedSecurityDomains;
    }

    public T trustedSecurityDomains(List<String> value) {
        List<String> oldValue = this.trustedSecurityDomains;
        this.trustedSecurityDomains = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trustedSecurityDomains", oldValue, value);
        }
        return (T)this;
    }

    public T trustedSecurityDomain(String value) {
        if (this.trustedSecurityDomains == null) {
            this.trustedSecurityDomains = new ArrayList<String>();
        }
        this.trustedSecurityDomains.add(value);
        return (T)this;
    }

    public T trustedSecurityDomains(String ... args) {
        this.trustedSecurityDomains(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

