/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.io;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=io/buffer-pool=*")
@ResourceType(value="buffer-pool")
public class BufferPool<T extends BufferPool<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The size of each buffer slice in bytes, if not set optimal value is calculated based on available RAM resources in your system.")
    private Integer bufferSize;
    @AttributeDocumentation(value="How many buffers per slice, if not set optimal value is calculated based on available RAM resources in your system.")
    private Integer buffersPerSlice;
    @AttributeDocumentation(value="Does the buffer pool use direct buffers, some platforms don't support direct buffers")
    private Boolean directBuffers;

    public BufferPool(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="buffer-size")
    public Integer bufferSize() {
        return this.bufferSize;
    }

    public T bufferSize(Integer value) {
        Integer oldValue = this.bufferSize;
        this.bufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffers-per-slice")
    public Integer buffersPerSlice() {
        return this.buffersPerSlice;
    }

    public T buffersPerSlice(Integer value) {
        Integer oldValue = this.buffersPerSlice;
        this.buffersPerSlice = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("buffersPerSlice", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="direct-buffers")
    public Boolean directBuffers() {
        return this.directBuffers;
    }

    public T directBuffers(Boolean value) {
        Boolean oldValue = this.directBuffers;
        this.directBuffers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("directBuffers", oldValue, value);
        }
        return (T)this;
    }
}

