/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.messaging.activemq.server.Role;
import org.wildfly.swarm.config.messaging.activemq.server.RoleConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RoleSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=messaging-activemq/server=*/core-address=*")
@ResourceType(value="core-address")
public class CoreAddress<T extends CoreAddress<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private CoreAddressResources subresources = new CoreAddressResources();
    @AttributeDocumentation(value="The names of all bindings (both queues and diverts) bound to this address.")
    private List<String> bindingNames;
    @AttributeDocumentation(value="The number of bytes used by each page for this address.")
    private Long numberOfBytesPerPage;
    @AttributeDocumentation(value="The number of pages used by this address.")
    private Integer numberOfPages;
    @AttributeDocumentation(value="The names of the queues associated with the address.")
    private List<String> queueNames;

    public CoreAddress(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public CoreAddressResources subresources() {
        return this.subresources;
    }

    public T roles(List<Role> value) {
        this.subresources.roles = value;
        return (T)this;
    }

    public T role(Role value) {
        this.subresources.roles.add(value);
        return (T)this;
    }

    public T role(String childKey, RoleConsumer consumer) {
        Role child = new Role(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.role(child);
        return (T)this;
    }

    public T role(String childKey) {
        this.role(childKey, null);
        return (T)this;
    }

    public T role(RoleSupplier supplier) {
        this.role(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="binding-names")
    public List<String> bindingNames() {
        return this.bindingNames;
    }

    public T bindingNames(List<String> value) {
        List<String> oldValue = this.bindingNames;
        this.bindingNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bindingNames", oldValue, value);
        }
        return (T)this;
    }

    public T bindingName(String value) {
        if (this.bindingNames == null) {
            this.bindingNames = new ArrayList<String>();
        }
        this.bindingNames.add(value);
        return (T)this;
    }

    public T bindingNames(String ... args) {
        this.bindingNames(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-bytes-per-page")
    public Long numberOfBytesPerPage() {
        return this.numberOfBytesPerPage;
    }

    public T numberOfBytesPerPage(Long value) {
        Long oldValue = this.numberOfBytesPerPage;
        this.numberOfBytesPerPage = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfBytesPerPage", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-pages")
    public Integer numberOfPages() {
        return this.numberOfPages;
    }

    public T numberOfPages(Integer value) {
        Integer oldValue = this.numberOfPages;
        this.numberOfPages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfPages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-names")
    public List<String> queueNames() {
        return this.queueNames;
    }

    public T queueNames(List<String> value) {
        List<String> oldValue = this.queueNames;
        this.queueNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueNames", oldValue, value);
        }
        return (T)this;
    }

    public T queueName(String value) {
        if (this.queueNames == null) {
            this.queueNames = new ArrayList<String>();
        }
        this.queueNames.add(value);
        return (T)this;
    }

    public T queueNames(String ... args) {
        this.queueNames(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    public static class CoreAddressResources {
        @ResourceDocumentation(value="A security role.")
        @SubresourceInfo(value="role")
        private List<Role> roles = new ArrayList<Role>();

        @Subresource
        public List<Role> roles() {
            return this.roles;
        }

        public Role role(String key) {
            return this.roles.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

