/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.remoting.PolicySASLPolicy;
import org.wildfly.swarm.config.remoting.PolicySASLPolicyConsumer;
import org.wildfly.swarm.config.remoting.PolicySASLPolicySupplier;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.remoting.PropertyConsumer;
import org.wildfly.swarm.config.remoting.PropertySupplier;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Addresses(value={"/subsystem=remoting/http-connector=*/security=sasl", "/subsystem=remoting/connector=*/security=sasl"})
@ResourceType(value="security")
@Implicit
public class SASLSecurity<T extends SASLSecurity<T>>
implements Keyed {
    private String key = "sasl";
    private PropertyChangeSupport pcs;
    private SASLSecurityResources subresources = new SASLSecurityResources();
    @AttributeDocumentation(value="The optional nested \"include-mechanisms\" element contains a whitelist of allowed SASL mechanism names. No mechanisms will be allowed which are not present in this list.")
    private List<String> includeMechanisms;
    @AttributeDocumentation(value="The optional nested \"qop\" element contains a list of quality-of-protection values, in decreasing order of preference.")
    private List<String> qop;
    @AttributeDocumentation(value="The optional nested \"reuse-session\" boolean element specifies whether or not the server should attempt to reuse previously authenticated session information.  The mechanism may or may not support such reuse, and other factors may also prevent it.")
    private Boolean reuseSession;
    @AttributeDocumentation(value="The optional nested \"server-auth\" boolean element specifies whether the server should authenticate to the client.  Not all mechanisms may support this setting.")
    private Boolean serverAuth;
    @AttributeDocumentation(value="The optional nested \"strength\" element contains a list of cipher strength values, in decreasing order of preference.")
    private List<String> strength;

    public SASLSecurity() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SASLSecurityResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    public T policySaslPolicy(PolicySASLPolicy value) {
        this.subresources.policySaslPolicy = value;
        return (T)this;
    }

    public T policySaslPolicy(PolicySASLPolicyConsumer consumer) {
        PolicySASLPolicy child = new PolicySASLPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.policySaslPolicy = child;
        return (T)this;
    }

    public T policySaslPolicy() {
        PolicySASLPolicy child = new PolicySASLPolicy();
        this.subresources.policySaslPolicy = child;
        return (T)this;
    }

    public T policySaslPolicy(PolicySASLPolicySupplier supplier) {
        this.subresources.policySaslPolicy = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="include-mechanisms")
    public List<String> includeMechanisms() {
        return this.includeMechanisms;
    }

    public T includeMechanisms(List<String> value) {
        List<String> oldValue = this.includeMechanisms;
        this.includeMechanisms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("includeMechanisms", oldValue, value);
        }
        return (T)this;
    }

    public T includeMechanism(String value) {
        if (this.includeMechanisms == null) {
            this.includeMechanisms = new ArrayList<String>();
        }
        this.includeMechanisms.add(value);
        return (T)this;
    }

    public T includeMechanisms(String ... args) {
        this.includeMechanisms(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="qop")
    public List<String> qop() {
        return this.qop;
    }

    public T qop(List<String> value) {
        List<String> oldValue = this.qop;
        this.qop = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("qop", oldValue, value);
        }
        return (T)this;
    }

    public T qop(String value) {
        if (this.qop == null) {
            this.qop = new ArrayList<String>();
        }
        this.qop.add(value);
        return (T)this;
    }

    public T qop(String ... args) {
        this.qop(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reuse-session")
    public Boolean reuseSession() {
        return this.reuseSession;
    }

    public T reuseSession(Boolean value) {
        Boolean oldValue = this.reuseSession;
        this.reuseSession = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reuseSession", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-auth")
    public Boolean serverAuth() {
        return this.serverAuth;
    }

    public T serverAuth(Boolean value) {
        Boolean oldValue = this.serverAuth;
        this.serverAuth = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverAuth", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="strength")
    public List<String> strength() {
        return this.strength;
    }

    public T strength(List<String> value) {
        List<String> oldValue = this.strength;
        this.strength = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("strength", oldValue, value);
        }
        return (T)this;
    }

    public T strength(String value) {
        if (this.strength == null) {
            this.strength = new ArrayList<String>();
        }
        this.strength.add(value);
        return (T)this;
    }

    public T strength(String ... args) {
        this.strength(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    public static class SASLSecurityResources {
        @ResourceDocumentation(value="Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.")
        @SubresourceInfo(value="property")
        private List<Property> properties = new ArrayList<Property>();
        @SingletonResource
        @ResourceDocumentation(value="The policy configuration.")
        private PolicySASLPolicy policySaslPolicy;

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public PolicySASLPolicy policySaslPolicy() {
            return this.policySaslPolicy;
        }
    }
}

