/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration.reverse_proxy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=undertow/configuration=handler/reverse-proxy=*/host=*")
@ResourceType(value="host")
public class Host<T extends Host<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="If this is true then the proxy will attempt to use HTTP/2 to connect to the backend. If it is not supported it will fall back to HTTP/1.1/")
    private Boolean enableHttp2;
    @AttributeDocumentation(value="The instance id (aka JVM route) that will be used to enable sticky sessions")
    private String instanceId;
    @AttributeDocumentation(value="Outbound socket binding for this host")
    private String outboundSocketBinding;
    @AttributeDocumentation(value="Optional path if host is using non root resource")
    private String path;
    @AttributeDocumentation(value="What kind of scheme is used")
    private String scheme;
    @AttributeDocumentation(value="The security realm that provides the SSL configuration for the connection to the host")
    private String securityRealm;
    @AttributeDocumentation(value="Reference to the SSLContext to be used by this handler.")
    private String sslContext;

    public Host(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="enable-http2")
    public Boolean enableHttp2() {
        return this.enableHttp2;
    }

    public T enableHttp2(Boolean value) {
        Boolean oldValue = this.enableHttp2;
        this.enableHttp2 = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableHttp2", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="instance-id")
    public String instanceId() {
        return this.instanceId;
    }

    public T instanceId(String value) {
        String oldValue = this.instanceId;
        this.instanceId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("instanceId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="outbound-socket-binding")
    public String outboundSocketBinding() {
        return this.outboundSocketBinding;
    }

    public T outboundSocketBinding(String value) {
        String oldValue = this.outboundSocketBinding;
        this.outboundSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outboundSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scheme")
    public String scheme() {
        return this.scheme;
    }

    public T scheme(String value) {
        String oldValue = this.scheme;
        this.scheme = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scheme", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-context")
    public String sslContext() {
        return this.sslContext;
    }

    public T sslContext(String value) {
        String oldValue = this.sslContext;
        this.sslContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslContext", oldValue, value);
        }
        return (T)this;
    }
}

