package org.wildfly.swarm.config;

import org.wildfly.swarm.config.JMX;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JMXConsumer<T extends JMX<T>> {

	/**
	 * Configure a pre-constructed instance of JMX resource
	 * 
	 * @parameter Instance of JMX to configure
	 * @return nothing
	 */
	void accept(T value);

	default JMXConsumer<T> andThen(JMXConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}