package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A mapping from a security domain referenced in a deployed application
 */
@Address("/subsystem=ejb3/application-security-domain=*")
@ResourceType("application-security-domain")
public class ApplicationSecurityDomain<T extends ApplicationSecurityDomain<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Enable authorization using JACC")
	private Boolean enableJacc;
	@AttributeDocumentation("The deployments currently referencing this mapping")
	private List<String> referencingDeployments;
	@AttributeDocumentation("The Elytron security domain to be used by deployments that reference the mapped security domain")
	private String securityDomain;

	public ApplicationSecurityDomain(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Enable authorization using JACC
	 */
	@ModelNodeBinding(detypedName = "enable-jacc")
	public Boolean enableJacc() {
		return this.enableJacc;
	}

	/**
	 * Enable authorization using JACC
	 */
	@SuppressWarnings("unchecked")
	public T enableJacc(java.lang.Boolean value) {
		Object oldValue = this.enableJacc;
		this.enableJacc = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableJacc", oldValue, value);
		return (T) this;
	}

	/**
	 * The deployments currently referencing this mapping
	 */
	@ModelNodeBinding(detypedName = "referencing-deployments")
	public List<String> referencingDeployments() {
		return this.referencingDeployments;
	}

	/**
	 * The deployments currently referencing this mapping
	 */
	@SuppressWarnings("unchecked")
	public T referencingDeployments(java.util.List<String> value) {
		Object oldValue = this.referencingDeployments;
		this.referencingDeployments = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("referencingDeployments", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The deployments currently referencing this mapping
	 */
	@SuppressWarnings("unchecked")
	public T referencingDeployment(String value) {
		if (this.referencingDeployments == null) {
			this.referencingDeployments = new java.util.ArrayList<>();
		}
		this.referencingDeployments.add(value);
		return (T) this;
	}

	/**
	 * The deployments currently referencing this mapping
	 */
	@SuppressWarnings("unchecked")
	public T referencingDeployments(String... args) {
		referencingDeployments(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The Elytron security domain to be used by deployments that reference the
	 * mapped security domain
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The Elytron security domain to be used by deployments that reference the
	 * mapped security domain
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}
}