package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregateHTTPServerMechanismFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregateHTTPServerMechanismFactoryConsumer<T extends AggregateHTTPServerMechanismFactory<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * AggregateHTTPServerMechanismFactory resource
	 * 
	 * @parameter Instance of AggregateHTTPServerMechanismFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregateHTTPServerMechanismFactoryConsumer<T> andThen(
			AggregateHTTPServerMechanismFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}