package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ConfigurableSASLServerFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConfigurableSASLServerFactoryConsumer<T extends ConfigurableSASLServerFactory<T>> {

	/**
	 * Configure a pre-constructed instance of ConfigurableSASLServerFactory
	 * resource
	 * 
	 * @parameter Instance of ConfigurableSASLServerFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigurableSASLServerFactoryConsumer<T> andThen(
			ConfigurableSASLServerFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}