package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Definition of a constant RealmMapper that always returns the same value.
 */
@Address("/subsystem=elytron/constant-realm-mapper=*")
@ResourceType("constant-realm-mapper")
public class ConstantRealmMapper<T extends ConstantRealmMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the constant realm to return.")
	private String realmName;

	public ConstantRealmMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the constant realm to return.
	 */
	@ModelNodeBinding(detypedName = "realm-name")
	public String realmName() {
		return this.realmName;
	}

	/**
	 * The name of the constant realm to return.
	 */
	@SuppressWarnings("unchecked")
	public T realmName(java.lang.String value) {
		Object oldValue = this.realmName;
		this.realmName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realmName", oldValue, value);
		return (T) this;
	}
}