package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A role mapper definition where a constant set of roles is always returned.
 */
@Address("/subsystem=elytron/constant-role-mapper=*")
@ResourceType("constant-role-mapper")
public class ConstantRoleMapper<T extends ConstantRoleMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The constant roles to be returned by this role mapper.")
	private List<String> roles;

	public ConstantRoleMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The constant roles to be returned by this role mapper.
	 */
	@ModelNodeBinding(detypedName = "roles")
	public List<String> roles() {
		return this.roles;
	}

	/**
	 * The constant roles to be returned by this role mapper.
	 */
	@SuppressWarnings("unchecked")
	public T roles(java.util.List<String> value) {
		Object oldValue = this.roles;
		this.roles = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("roles", oldValue, value);
		return (T) this;
	}

	/**
	 * The constant roles to be returned by this role mapper.
	 */
	@SuppressWarnings("unchecked")
	public T role(String value) {
		if (this.roles == null) {
			this.roles = new java.util.ArrayList<>();
		}
		this.roles.add(value);
		return (T) this;
	}

	/**
	 * The constant roles to be returned by this role mapper.
	 */
	@SuppressWarnings("unchecked")
	public T roles(String... args) {
		roles(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}