package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A security realm definition backed by database using JDBC.
 */
@Address("/subsystem=elytron/jdbc-realm=*")
@ResourceType("jdbc-realm")
public class JDBCRealm<T extends JDBCRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The authentication query used to authenticate users based on specific key types.")
	private List<java.util.Map> principalQuery;

	public JDBCRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The authentication query used to authenticate users based on specific key
	 * types.
	 */
	@ModelNodeBinding(detypedName = "principal-query")
	public List<Map> principalQuery() {
		return this.principalQuery;
	}

	/**
	 * The authentication query used to authenticate users based on specific key
	 * types.
	 */
	@SuppressWarnings("unchecked")
	public T principalQuery(java.util.List<java.util.Map> value) {
		Object oldValue = this.principalQuery;
		this.principalQuery = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalQuery", oldValue, value);
		return (T) this;
	}

	/**
	 * The authentication query used to authenticate users based on specific key
	 * types.
	 */
	@SuppressWarnings("unchecked")
	public T principalQuery(java.util.Map value) {
		if (this.principalQuery == null) {
			this.principalQuery = new java.util.ArrayList<>();
		}
		this.principalQuery.add(value);
		return (T) this;
	}

	/**
	 * The authentication query used to authenticate users based on specific key
	 * types.
	 */
	@SuppressWarnings("unchecked")
	public T principalQuery(java.util.Map... args) {
		principalQuery(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}