package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Definition of a RealmMapper implementation that first uses a regular
 * expression to extract the realm name, this is then converted using the
 * configured mapping of realm names.
 */
@Address("/subsystem=elytron/mapped-regex-realm-mapper=*")
@ResourceType("mapped-regex-realm-mapper")
public class MappedRegexRealmMapper<T extends MappedRegexRealmMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The RealmMapper to delegate to if the pattern does not match. If no delegate is specified then the default realm on the domain will be used instead. If the username does not match the pattern and a delegate realm-mapper is present, the result of delegate-realm-mapper is mapped via the realm-map.")
	private String delegateRealmMapper;
	@AttributeDocumentation("The regular expression which must contain at least one capture group to extract the realm from the name. If the regular expression matches more than one capture group, the first capture group is used.")
	private String pattern;
	@AttributeDocumentation("Mapping of realm name extracted using the regular expression to a defined realm name. If the value for the mapping is not in the map or the realm whose name is the result of the mapping does not exist in the given security domain, the default realm is used.")
	private Map realmMap;

	public MappedRegexRealmMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The RealmMapper to delegate to if the pattern does not match. If no
	 * delegate is specified then the default realm on the domain will be used
	 * instead. If the username does not match the pattern and a delegate
	 * realm-mapper is present, the result of delegate-realm-mapper is mapped
	 * via the realm-map.
	 */
	@ModelNodeBinding(detypedName = "delegate-realm-mapper")
	public String delegateRealmMapper() {
		return this.delegateRealmMapper;
	}

	/**
	 * The RealmMapper to delegate to if the pattern does not match. If no
	 * delegate is specified then the default realm on the domain will be used
	 * instead. If the username does not match the pattern and a delegate
	 * realm-mapper is present, the result of delegate-realm-mapper is mapped
	 * via the realm-map.
	 */
	@SuppressWarnings("unchecked")
	public T delegateRealmMapper(java.lang.String value) {
		Object oldValue = this.delegateRealmMapper;
		this.delegateRealmMapper = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("delegateRealmMapper", oldValue, value);
		return (T) this;
	}

	/**
	 * The regular expression which must contain at least one capture group to
	 * extract the realm from the name. If the regular expression matches more
	 * than one capture group, the first capture group is used.
	 */
	@ModelNodeBinding(detypedName = "pattern")
	public String pattern() {
		return this.pattern;
	}

	/**
	 * The regular expression which must contain at least one capture group to
	 * extract the realm from the name. If the regular expression matches more
	 * than one capture group, the first capture group is used.
	 */
	@SuppressWarnings("unchecked")
	public T pattern(java.lang.String value) {
		Object oldValue = this.pattern;
		this.pattern = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("pattern", oldValue, value);
		return (T) this;
	}

	/**
	 * Mapping of realm name extracted using the regular expression to a defined
	 * realm name. If the value for the mapping is not in the map or the realm
	 * whose name is the result of the mapping does not exist in the given
	 * security domain, the default realm is used.
	 */
	@ModelNodeBinding(detypedName = "realm-map")
	public Map realmMap() {
		return this.realmMap;
	}

	/**
	 * Mapping of realm name extracted using the regular expression to a defined
	 * realm name. If the value for the mapping is not in the map or the realm
	 * whose name is the result of the mapping does not exist in the given
	 * security domain, the default realm is used.
	 */
	@SuppressWarnings("unchecked")
	public T realmMap(java.util.Map value) {
		Object oldValue = this.realmMap;
		this.realmMap = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realmMap", oldValue, value);
		return (T) this;
	}

	/**
	 * Mapping of realm name extracted using the regular expression to a defined
	 * realm name. If the value for the mapping is not in the map or the realm
	 * whose name is the result of the mapping does not exist in the given
	 * security domain, the default realm is used.
	 */
	@SuppressWarnings("unchecked")
	public T realmMap(java.lang.String key, java.lang.Object value) {
		if (this.realmMap == null) {
			this.realmMap = new java.util.HashMap<>();
		}
		this.realmMap.put(key, value);
		return (T) this;
	}
}