package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.elytron.Format;

/**
 * An audit log definition for persisting an audit log to a local files rotating
 * the log after a time period derived from the given suffix string, which
 * should be in a format understood by java.time.format.DateTimeFormatter.
 */
@Address("/subsystem=elytron/periodic-rotating-file-audit-log=*")
@ResourceType("periodic-rotating-file-audit-log")
public class PeriodicRotatingFileAuditLog<T extends PeriodicRotatingFileAuditLog<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The format to use to record the audit event.")
	private Format format;
	@AttributeDocumentation("The suffix string in a format which can be understood by java.time.format.DateTimeFormatter. The period of the rotation is automatically calculated based on the suffix.")
	private String suffix;
	@AttributeDocumentation("Whether every event should be immediately synchronised to disk.")
	private Boolean attributeSynchronized;
	@AttributeDocumentation("Path of the file to be written.")
	private String path;
	@AttributeDocumentation("The relative path to the audit log.")
	private String relativeTo;

	public PeriodicRotatingFileAuditLog(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The format to use to record the audit event.
	 */
	@ModelNodeBinding(detypedName = "format")
	public Format format() {
		return this.format;
	}

	/**
	 * The format to use to record the audit event.
	 */
	@SuppressWarnings("unchecked")
	public T format(Format value) {
		Object oldValue = this.format;
		this.format = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("format", oldValue, value);
		return (T) this;
	}

	/**
	 * The suffix string in a format which can be understood by
	 * java.time.format.DateTimeFormatter. The period of the rotation is
	 * automatically calculated based on the suffix.
	 */
	@ModelNodeBinding(detypedName = "suffix")
	public String suffix() {
		return this.suffix;
	}

	/**
	 * The suffix string in a format which can be understood by
	 * java.time.format.DateTimeFormatter. The period of the rotation is
	 * automatically calculated based on the suffix.
	 */
	@SuppressWarnings("unchecked")
	public T suffix(java.lang.String value) {
		Object oldValue = this.suffix;
		this.suffix = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("suffix", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether every event should be immediately synchronised to disk.
	 */
	@ModelNodeBinding(detypedName = "synchronized")
	public Boolean attributeSynchronized() {
		return this.attributeSynchronized;
	}

	/**
	 * Whether every event should be immediately synchronised to disk.
	 */
	@SuppressWarnings("unchecked")
	public T attributeSynchronized(java.lang.Boolean value) {
		Object oldValue = this.attributeSynchronized;
		this.attributeSynchronized = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeSynchronized", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Path of the file to be written.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Path of the file to be written.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The relative path to the audit log.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The relative path to the audit log.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}
}