package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.PeriodicRotatingFileAuditLog;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PeriodicRotatingFileAuditLogConsumer<T extends PeriodicRotatingFileAuditLog<T>> {

	/**
	 * Configure a pre-constructed instance of PeriodicRotatingFileAuditLog
	 * resource
	 * 
	 * @parameter Instance of PeriodicRotatingFileAuditLog to configure
	 * @return nothing
	 */
	void accept(T value);

	default PeriodicRotatingFileAuditLogConsumer<T> andThen(
			PeriodicRotatingFileAuditLogConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}