package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ServiceLoaderSASLServerFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ServiceLoaderSASLServerFactoryConsumer<T extends ServiceLoaderSASLServerFactory<T>> {

	/**
	 * Configure a pre-constructed instance of ServiceLoaderSASLServerFactory
	 * resource
	 * 
	 * @parameter Instance of ServiceLoaderSASLServerFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default ServiceLoaderSASLServerFactoryConsumer<T> andThen(
			ServiceLoaderSASLServerFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}