package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.SizeRotatingFileAuditLog;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SizeRotatingFileAuditLogConsumer<T extends SizeRotatingFileAuditLog<T>> {

	/**
	 * Configure a pre-constructed instance of SizeRotatingFileAuditLog resource
	 * 
	 * @parameter Instance of SizeRotatingFileAuditLog to configure
	 * @return nothing
	 */
	void accept(T value);

	default SizeRotatingFileAuditLogConsumer<T> andThen(
			SizeRotatingFileAuditLogConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}