package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Defines a thread pool used for for evictions.
 */
@Address("/subsystem=infinispan/cache-container=*/thread-pool=expiration")
@ResourceType("thread-pool")
@Implicit
public class ExpirationThreadPool<T extends ExpirationThreadPool<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.")
	private Long keepaliveTime;
	@AttributeDocumentation("The maximum thread pool size.")
	private Integer maxThreads;

	public ExpirationThreadPool() {
		super();
		this.key = "expiration";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be
	 * kept running when idle; if not specified, threads will run until the
	 * executor is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be
	 * kept running when idle; if not specified, threads will run until the
	 * executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(java.lang.Long value) {
		Object oldValue = this.keepaliveTime;
		this.keepaliveTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keepaliveTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T maxThreads(java.lang.Integer value) {
		Object oldValue = this.maxThreads;
		this.maxThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxThreads", oldValue, value);
		return (T) this;
	}
}