package org.wildfly.swarm.config.io.worker;

import org.wildfly.swarm.config.io.worker.OutboundBindAddress;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface OutboundBindAddressConsumer<T extends OutboundBindAddress<T>> {

	/**
	 * Configure a pre-constructed instance of OutboundBindAddress resource
	 * 
	 * @parameter Instance of OutboundBindAddress to configure
	 * @return nothing
	 */
	void accept(T value);

	default OutboundBindAddressConsumer<T> andThen(
			OutboundBindAddressConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}