package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.security.ElytronRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ElytronRealmConsumer<T extends ElytronRealm<T>> {

	/**
	 * Configure a pre-constructed instance of ElytronRealm resource
	 * 
	 * @parameter Instance of ElytronRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default ElytronRealmConsumer<T> andThen(ElytronRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}