package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.undertow.server.host.HTTPInvokerSetting;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface HTTPInvokerSettingConsumer<T extends HTTPInvokerSetting<T>> {

	/**
	 * Configure a pre-constructed instance of HTTPInvokerSetting resource
	 * 
	 * @parameter Instance of HTTPInvokerSetting to configure
	 * @return nothing
	 */
	void accept(T value);

	default HTTPInvokerSettingConsumer<T> andThen(
			HTTPInvokerSettingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}