package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface WelcomeFileConsumer<T extends WelcomeFile<T>> {

	/**
	 * Configure a pre-constructed instance of WelcomeFile resource
	 * 
	 * @parameter Instance of WelcomeFile to configure
	 * @return nothing
	 */
	void accept(T value);

	default WelcomeFileConsumer<T> andThen(WelcomeFileConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}