/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=request-controller")
@ResourceType(value="subsystem")
@Implicit
public class RequestController<T extends RequestController<T>>
implements Keyed {
    private String key = "request-controller";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The number of requests that are currently running in the server")
    private Integer activeRequests;
    @AttributeDocumentation(value="The maximum number of all types of requests that can be running in a server at a time. Once this limit is hit any new requests will be rejected.")
    private Integer maxRequests;
    @AttributeDocumentation(value="If this is true requests are tracked at an endpoint level, which will allow individual deployments to be suspended")
    private Boolean trackIndividualEndpoints;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="active-requests")
    public Integer activeRequests() {
        return this.activeRequests;
    }

    public T activeRequests(Integer value) {
        Integer oldValue = this.activeRequests;
        this.activeRequests = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("activeRequests", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-requests")
    public Integer maxRequests() {
        return this.maxRequests;
    }

    public T maxRequests(Integer value) {
        Integer oldValue = this.maxRequests;
        this.maxRequests = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRequests", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="track-individual-endpoints")
    public Boolean trackIndividualEndpoints() {
        return this.trackIndividualEndpoints;
    }

    public T trackIndividualEndpoints(Boolean value) {
        Boolean oldValue = this.trackIndividualEndpoints;
        this.trackIndividualEndpoints = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trackIndividualEndpoints", oldValue, value);
        }
        return (T)this;
    }
}

