/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ejb3/strict-max-bean-instance-pool=*")
@ResourceType(value="strict-max-bean-instance-pool")
public class StrictMaxBeanInstancePool<T extends StrictMaxBeanInstancePool<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Specifies if and what the max pool size should be derived from. An undefined value (or the deprecated value 'none' which is converted to undefined) indicates that the explicit value of max-pool-size should be used. A value of 'from-worker-pools' indicates that the max pool size should be derived from the size of the total threads for all worker pools configured on the system. A value of 'from-cpu-count' indicates that the max pool size should be derived from the total number of processors available on the system. Note that the computation isn't a 1:1 mapping, the values may or may not be augmented by other factors.")
    private DeriveSize deriveSize;
    @AttributeDocumentation(value="The maximum number of bean instances that the pool can hold at a given point in time")
    private Integer maxPoolSize;
    @AttributeDocumentation(value="The maximum amount of time to wait for a bean instance to be available from the pool")
    private Long timeout;
    @AttributeDocumentation(value="The instance acquisition timeout unit")
    private TimeoutUnit timeoutUnit;

    public StrictMaxBeanInstancePool(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="derive-size")
    public DeriveSize deriveSize() {
        return this.deriveSize;
    }

    public T deriveSize(DeriveSize value) {
        DeriveSize oldValue = this.deriveSize;
        this.deriveSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deriveSize", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-pool-size")
    public Integer maxPoolSize() {
        return this.maxPoolSize;
    }

    public T maxPoolSize(Integer value) {
        Integer oldValue = this.maxPoolSize;
        this.maxPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="timeout")
    public Long timeout() {
        return this.timeout;
    }

    public T timeout(Long value) {
        Long oldValue = this.timeout;
        this.timeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="timeout-unit")
    public TimeoutUnit timeoutUnit() {
        return this.timeoutUnit;
    }

    public T timeoutUnit(TimeoutUnit value) {
        TimeoutUnit oldValue = this.timeoutUnit;
        this.timeoutUnit = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeoutUnit", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    public static enum TimeoutUnit {
        NANOSECONDS("NANOSECONDS"),
        MICROSECONDS("MICROSECONDS"),
        MILLISECONDS("MILLISECONDS"),
        SECONDS("SECONDS"),
        MINUTES("MINUTES"),
        HOURS("HOURS"),
        DAYS("DAYS");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private TimeoutUnit(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum DeriveSize {
        FROM_WORKER_POOLS("from-worker-pools"),
        FROM_CPU_COUNT("from-cpu-count");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private DeriveSize(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

