/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/custom-realm=*")
@ResourceType(value="custom-realm")
public class CustomRealm<T extends CustomRealm<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The optional key/value configuration for the custom realm.")
    private Map configuration;
    @AttributeDocumentation(value="The class name of the implementation of the custom realm.")
    private String className;
    @AttributeDocumentation(value="The module to use to load the custom realm.")
    private String module;

    public CustomRealm(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="configuration")
    public Map configuration() {
        return this.configuration;
    }

    public T configuration(Map value) {
        Map oldValue = this.configuration;
        this.configuration = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("configuration", oldValue, value);
        }
        return (T)this;
    }

    public T configuration(String key, Object value) {
        if (this.configuration == null) {
            this.configuration = new HashMap();
        }
        this.configuration.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="class-name")
    public String className() {
        return this.className;
    }

    public T className(String value) {
        String oldValue = this.className;
        this.className = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("className", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }
}

